/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource;

import com.maxifier.mxcache.InternalProbeFailedError;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.nodes.ResourceViewable;
import com.maxifier.mxcache.util.HashWeakReference;
import com.maxifier.mxcache.util.TIdentityHashSet;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DependencyTracker {
    private static final ThreadLocal<DependencyNode> NODE = new ThreadLocal();
    public static final DependencyNode DUMMY_NODE = new DummyDependencyNode("<DUMMY>");
    public static final DependencyNode PROBE_NODE = new DummyDependencyNode("<PROBE>");
    public static final DependencyNode NOCACHE_NODE = new DummyDependencyNode("<NOCACHE>");
    public static final DependencyNode HIDDEN_CALLER_NODE = new HiddenCallerDependencyNode();

    private DependencyTracker() {
    }

    public static void mark(DependencyNode node) {
        if (node != DUMMY_NODE) {
            DependencyTracker.track(node, NODE.get());
        }
    }

    public static DependencyNode track(DependencyNode node) {
        DependencyNode oldNode = NODE.get();
        assert (oldNode == null || node != null) : "Could not reassign node to null";
        if (oldNode == PROBE_NODE) {
            throw new InternalProbeFailedError();
        }
        if (node != DUMMY_NODE) {
            DependencyTracker.track(node, oldNode);
            NODE.set(node);
        } else if (oldNode == null) {
            NODE.set(node);
        }
        return oldNode;
    }

    private static void track(DependencyNode node, DependencyNode oldNode) {
        if (oldNode != null && oldNode != DUMMY_NODE && node != oldNode) {
            node.trackDependency(oldNode);
        }
    }

    public static void exit(@Nullable DependencyNode callerNode) {
        NODE.set(callerNode);
    }

    public static DependencyNode get() {
        return NODE.get();
    }

    public static boolean hasUnderlyingNode() {
        return NODE.get() != null;
    }

    public static void deepVisit(Iterable<DependencyNode> src, DependencyNode.Visitor visitor) {
        for (DependencyNode node : src) {
            visitor.visit(node);
        }
        Queue<DependencyNode> queue = visitor.getQueue();
        while (!queue.isEmpty()) {
            queue.poll().visitDependantNodes(visitor);
        }
    }

    public static boolean isDummyNode(DependencyNode node) {
        return node instanceof DummyDependencyNode;
    }

    public static boolean isBypassCaches() {
        return NOCACHE_NODE.equals(DependencyTracker.get());
    }

    public static void deepInvalidate(DependencyNode node) {
        DependencyTracker.deepVisit(Collections.singleton(node), new InvalidateAllVisitor());
    }

    public static void deepInvalidateWithResourceView(DependencyNode node) {
        DependencyTracker.deepVisit(Collections.singleton(node), new InvalidateChangedVisitor());
    }

    public static void deepInvalidate(Collection<? extends CleaningNode> elements) {
        DependencyTracker.deepInvalidate(new WrapDependencyNode(elements));
    }

    private static class InvalidateChangedVisitor
    implements DependencyNode.Visitor {
        private final Queue<DependencyNode> queue = new LinkedList<DependencyNode>();
        private final TIdentityHashSet<DependencyNode> visitedNodes = new TIdentityHashSet();
        private final Map<ResourceViewable, Boolean> changedCache = new TCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);

        private InvalidateChangedVisitor() {
        }

        private boolean isChanged(ResourceViewable resourceViewable) {
            Boolean res = this.changedCache.get(resourceViewable);
            if (res == null) {
                res = resourceViewable.isChanged();
                this.changedCache.put(resourceViewable, res);
            }
            return res;
        }

        @Override
        public Queue<DependencyNode> getQueue() {
            return this.queue;
        }

        @Override
        public void visit(DependencyNode node) {
            if (this.visitedNodes.add(node) && (!(node instanceof ResourceViewable) || this.isChanged((ResourceViewable)((Object)node)))) {
                this.queue.add(node);
                node.invalidate();
            }
        }
    }

    private static class InvalidateAllVisitor
    implements DependencyNode.Visitor {
        private final Queue<DependencyNode> queue = new LinkedList<DependencyNode>();
        private final TIdentityHashSet<DependencyNode> visitedNodes = new TIdentityHashSet();

        private InvalidateAllVisitor() {
        }

        @Override
        public Queue<DependencyNode> getQueue() {
            return this.queue;
        }

        @Override
        public void visit(DependencyNode node) {
            if (this.visitedNodes.add(node)) {
                this.queue.add(node);
                node.invalidate();
            }
        }
    }

    private static class WrapDependencyNode
    implements DependencyNode {
        private final Collection<? extends CleaningNode> elements;

        public WrapDependencyNode(Collection<? extends CleaningNode> elements) {
            this.elements = elements;
        }

        @Override
        public Reference<DependencyNode> getSelfReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitDependantNodes(DependencyNode.Visitor visitor) {
            for (CleaningNode cleaningNode : this.elements) {
                visitor.visit(cleaningNode.getDependencyNode());
            }
        }

        @Override
        public void trackDependency(DependencyNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invalidate() {
            for (CleaningNode cleaningNode : this.elements) {
                cleaningNode.invalidate();
            }
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
            throw new UnsupportedOperationException();
        }
    }

    private static class HiddenCallerDependencyNode
    implements DependencyNode {
        private final Reference<DependencyNode> thisReference = new WeakReference<HiddenCallerDependencyNode>(this);

        private HiddenCallerDependencyNode() {
        }

        @Override
        public Reference<DependencyNode> getSelfReference() {
            return this.thisReference;
        }

        @Override
        public void visitDependantNodes(DependencyNode.Visitor visitor) {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void trackDependency(DependencyNode node) {
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
        }

        public String toString() {
            return "HiddenCaller - see MxCache.hideCallerDependencies";
        }
    }

    private static final class DummyDependencyNode
    implements DependencyNode {
        private final Reference<DependencyNode> selfReference = new HashWeakReference<DummyDependencyNode>(this);
        private final String name;

        private DummyDependencyNode(String name) {
            this.name = name;
        }

        @Override
        public void visitDependantNodes(DependencyNode.Visitor visitor) {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void trackDependency(DependencyNode node) {
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Reference<DependencyNode> getSelfReference() {
            return this.selfReference;
        }
    }
}

