/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource;

import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.impl.resource.AbstractDependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.resource.MxResource;
import com.maxifier.mxcache.resource.ResourceModificationException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MxResourceImpl
extends AbstractDependencyNode
implements MxResource,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MxResourceImpl.class);
    private static final long serialVersionUID = 100L;
    protected final Object owner;
    @Nonnull
    private final String name;
    private final ReentrantReadWriteLock lock;
    private final Lock readLock;
    private final Lock writeLock;
    private final ResourceReadLock resourceReadLock;
    private final ResourceWriteLock resourceWriteLock;
    private boolean cleaning;

    public MxResourceImpl(Object owner, @Nonnull String name) {
        this.owner = owner;
        this.name = name;
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.resourceReadLock = new ResourceReadLock();
        this.resourceWriteLock = new ResourceWriteLock();
    }

    @Override
    public void readStart() throws ResourceModificationException {
        this.resourceReadLock.lock();
    }

    @Override
    public void readEnd() {
        this.resourceReadLock.unlock();
    }

    @Override
    public void writeStart() throws ResourceModificationException {
        this.resourceWriteLock.lock();
    }

    @Override
    public void writeEnd() {
        this.resourceWriteLock.unlock();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReading() {
        return this.lock.getReadHoldCount() > 0;
    }

    @Override
    public boolean isWriting() {
        return this.lock.isWriteLocked();
    }

    @Override
    public void waitForEndOfModification() {
        if (this.lock.isWriteLocked() && logger.isTraceEnabled()) {
            logger.trace("Thread {} is waiting for resource \"{}\"", (Object)Thread.currentThread(), (Object)this);
        }
        this.readLock.lock();
        try {
            if (this.lock.isWriteLockedByCurrentThread()) {
                throw new ResourceModificationException("Current thread (" + Thread.currentThread() + ") has already locked resource \"" + this + "\" for write");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clearDependentCaches() {
        DependencyTracker.deepInvalidate(this);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void addNode(@Nonnull CleaningNode cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate() {
    }

    @Override
    @Nonnull
    public Lock readLock() {
        return this.resourceReadLock;
    }

    @Override
    @Nonnull
    public Lock writeLock() {
        return this.resourceWriteLock;
    }

    private class ResourceWriteLock
    implements Lock,
    Serializable {
        private ResourceWriteLock() {
        }

        @Override
        public void lock() {
            if (DependencyTracker.hasUnderlyingNode()) {
                throw new ResourceModificationException("Resource \"" + MxResourceImpl.this.name + "\" modification is required while cache " + DependencyTracker.get() + " is found on the stack");
            }
            MxResourceImpl.this.writeLock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (DependencyTracker.hasUnderlyingNode()) {
                throw new ResourceModificationException("Resource \"" + MxResourceImpl.this.name + "\" modification is required while cache " + DependencyTracker.get() + " is found on the stack");
            }
            MxResourceImpl.this.writeLock.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            if (DependencyTracker.hasUnderlyingNode()) {
                throw new ResourceModificationException("Resource \"" + MxResourceImpl.this.name + "\" modification is required while cache " + DependencyTracker.get() + " is found on the stack");
            }
            return MxResourceImpl.this.writeLock.tryLock();
        }

        @Override
        public boolean tryLock(long time, @Nonnull TimeUnit unit) throws InterruptedException {
            if (DependencyTracker.hasUnderlyingNode()) {
                throw new ResourceModificationException("Resource \"" + MxResourceImpl.this.name + "\" modification is required while cache " + DependencyTracker.get() + " is found on the stack");
            }
            return MxResourceImpl.this.writeLock.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            if (!MxResourceImpl.this.lock.isWriteLockedByCurrentThread()) {
                throw new IllegalStateException("clearDependentCachesInternal is invoked with write lock held");
            }
            try {
                MxResourceImpl.this.cleaning = true;
                DependencyTracker.deepInvalidateWithResourceView(MxResourceImpl.this);
                MxResourceImpl.this.cleaning = false;
            }
            finally {
                MxResourceImpl.this.writeLock.unlock();
            }
        }

        @Override
        @Nonnull
        public Condition newCondition() {
            return MxResourceImpl.this.writeLock.newCondition();
        }
    }

    private class ResourceReadLock
    implements Lock,
    Serializable {
        private ResourceReadLock() {
        }

        @Override
        public void lock() {
            DependencyNode node = DependencyTracker.get();
            if (node == null) {
                MxResourceImpl.this.readLock.lock();
            } else {
                this.lockFromCache(node);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            DependencyNode node = DependencyTracker.get();
            if (node == null) {
                MxResourceImpl.this.readLock.lockInterruptibly();
            } else {
                this.lockFromCache(node);
            }
        }

        @Override
        public boolean tryLock() {
            DependencyNode node = DependencyTracker.get();
            if (node == null) {
                return MxResourceImpl.this.readLock.tryLock();
            }
            this.lockFromCache(node);
            return true;
        }

        @Override
        public boolean tryLock(long time, @Nonnull TimeUnit unit) throws InterruptedException {
            DependencyNode node = DependencyTracker.get();
            if (node == null) {
                return MxResourceImpl.this.readLock.tryLock(time, unit);
            }
            this.lockFromCache(node);
            return true;
        }

        private void lockFromCache(DependencyNode node) {
            if (MxResourceImpl.this.lock.isWriteLockedByCurrentThread() && !MxResourceImpl.this.cleaning) {
                throw new ResourceModificationException("Resource \"" + MxResourceImpl.this.name + "\" is already being written from current thread");
            }
            if (!MxResourceImpl.this.readLock.tryLock()) {
                throw new ResourceOccupied(MxResourceImpl.this);
            }
            if (!DependencyTracker.isDummyNode(node)) {
                MxResourceImpl.this.trackDependency(node);
            }
        }

        @Override
        public void unlock() {
            MxResourceImpl.this.readLock.unlock();
        }

        @Override
        @Nonnull
        public Condition newCondition() {
            return MxResourceImpl.this.readLock.newCondition();
        }
    }
}

