/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.wrapping;

import com.maxifier.mxcache.transform.TransformGenerator;
import javax.annotation.Nonnull;

class CacheImplementationSignature {
    private final Class cacheClass;
    private final Class calculatableClass;
    private final Class storageClass;
    @Nonnull
    private final TransformGenerator userKeyTransformer;
    @Nonnull
    private final TransformGenerator userValueTransformer;
    private final boolean perElementLocking;
    private final int hash;

    public CacheImplementationSignature(Class cacheClass, Class calculatableClass, Class storageClass, @Nonnull TransformGenerator userKeyTransformer, @Nonnull TransformGenerator userValueTransformer, boolean perElementLocking) {
        this.cacheClass = cacheClass;
        this.calculatableClass = calculatableClass;
        this.storageClass = storageClass;
        this.userKeyTransformer = userKeyTransformer;
        this.userValueTransformer = userValueTransformer;
        this.perElementLocking = perElementLocking;
        int hash = cacheClass.hashCode();
        hash = 31 * hash + storageClass.hashCode();
        hash = 31 * hash + userKeyTransformer.hashCode();
        hash = 31 * hash + userValueTransformer.hashCode();
        this.hash = perElementLocking ? hash : ~hash;
    }

    public Class getCacheClass() {
        return this.cacheClass;
    }

    public Class getCalculatableClass() {
        return this.calculatableClass;
    }

    public Class getStorageClass() {
        return this.storageClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheImplementationSignature w = (CacheImplementationSignature)o;
        return this.cacheClass == w.cacheClass && this.storageClass == w.storageClass && this.userKeyTransformer.equals(w.userKeyTransformer) && this.userValueTransformer.equals(w.userValueTransformer) && this.perElementLocking == w.perElementLocking;
    }

    public int hashCode() {
        return this.hash;
    }
}

