/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.mbean;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.resource.MxResourceFactory;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.mbean.CacheControlMXBean;
import com.maxifier.mxcache.mbean.CacheInfo;
import com.maxifier.mxcache.mbean.ResourceInfo;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.provider.CacheProvider;
import com.maxifier.mxcache.resource.MxResource;
import com.maxifier.mxcache.util.TIdentityHashSet;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class CacheControl
implements CacheControlMXBean {
    private final CacheProvider provider;

    public CacheControl(@Nonnull CacheProvider provider) {
        this.provider = provider;
    }

    @Override
    public String getCacheProviderImpl() {
        return CacheControl.getDisplayName(this.provider.getClass());
    }

    @Override
    public List<ResourceInfo> getResources() {
        Set<MxResource> resources = MxResourceFactory.getAllResources();
        ArrayList<ResourceInfo> res = new ArrayList<ResourceInfo>(resources.size());
        for (MxResource resource : resources) {
            res.add(new ResourceInfo(resource.getName()));
        }
        return res;
    }

    @Override
    public List<CacheInfo> getCaches() {
        List<CacheManager> caches = this.provider.getCaches();
        ArrayList<CacheInfo> res = new ArrayList<CacheInfo>(caches.size());
        for (CacheManager cacheManager : caches) {
            String impl;
            try {
                impl = cacheManager.getImplementationDetails();
            }
            catch (RuntimeException e) {
                impl = "Error: " + e.getMessage();
            }
            int count = 0;
            int total = 0;
            int totalHits = 0;
            int totalMisses = 0;
            double averageCalculation = 0.0;
            TIdentityHashSet statisticsSet = new TIdentityHashSet();
            try {
                for (Cache c : CacheFactory.getCaches(cacheManager.getDescriptor())) {
                    ++count;
                    total += c.getSize();
                    Statistics stat = c.getStatistics();
                    if (stat == null) continue;
                    statisticsSet.add((Statistics)stat);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Iterator<Cache> iterator = statisticsSet.iterator();
            while (iterator.hasNext()) {
                Statistics statistics = (Statistics)((Object)iterator.next());
                totalHits += statistics.getHits();
                totalMisses += statistics.getMisses();
                averageCalculation += (double)statistics.getTotalCalculationTime();
            }
            CacheDescriptor descriptor = cacheManager.getDescriptor();
            Class<?> ownerClass = cacheManager.getOwnerClass();
            CacheContext context = cacheManager.getContext();
            res.add(new CacheInfo(context == null ? "<no context>" : context.toString(), descriptor.getKeyType() == null ? null : CacheControl.getDisplayName(descriptor.getKeyType()), CacheControl.getDisplayName(descriptor.getValueType()), descriptor.getMethod().toGenericString(), descriptor.getCacheName(), descriptor.getId(), count, total, descriptor.getGroup(), descriptor.getTags(), impl, CacheControl.getDisplayName(ownerClass), CacheControl.getDisplayName(descriptor.getDeclaringClass()), totalHits, totalMisses, totalMisses == 0 ? 0.0 : averageCalculation / (double)totalMisses));
        }
        return res;
    }

    @Override
    public Map<String, List<CacheInfo>> getCachesByGroup() {
        THashMap res = new THashMap();
        for (CacheInfo cacheInfo : this.getCaches()) {
            String group = cacheInfo.getGroup();
            ArrayList<CacheInfo> list = (ArrayList<CacheInfo>)res.get(group);
            if (list == null) {
                list = new ArrayList<CacheInfo>();
                res.put(group, list);
            }
            list.add(cacheInfo);
        }
        return res;
    }

    @Override
    public Map<String, List<CacheInfo>> getCachesByClass() {
        THashMap res = new THashMap();
        for (CacheInfo cacheInfo : this.getCaches()) {
            String owner = cacheInfo.getOwner();
            ArrayList<CacheInfo> list = (ArrayList<CacheInfo>)res.get(owner);
            if (list == null) {
                list = new ArrayList<CacheInfo>();
                res.put(owner, list);
            }
            list.add(cacheInfo);
        }
        return res;
    }

    @Override
    public Map<String, List<CacheInfo>> getCachesByTag() {
        THashMap res = new THashMap();
        for (CacheInfo cacheInfo : this.getCaches()) {
            String[] tags = cacheInfo.getTags();
            if (tags == null) continue;
            for (String tag : tags) {
                ArrayList<CacheInfo> list = (ArrayList<CacheInfo>)res.get(tag);
                if (list == null) {
                    list = new ArrayList<CacheInfo>();
                    res.put(tag, list);
                }
                list.add(cacheInfo);
            }
        }
        return res;
    }

    @Override
    public void clearByGroup(String group) {
        CacheFactory.getCleaner().clearCacheByGroup(group);
    }

    @Override
    public void clearByTag(String tag) {
        CacheFactory.getCleaner().clearCacheByGroup(tag);
    }

    @Override
    public void clearByClass(String className) throws ClassNotFoundException {
        CacheFactory.getCleaner().clearCacheByClass(Class.forName(className));
    }

    @Override
    public void clearByResource(String resourceName) {
        MxResourceFactory.getResource(resourceName).clearDependentCaches();
    }

    private static String getDisplayName(Class<?> ownerClass) {
        String canonicalName = ownerClass.getCanonicalName();
        return canonicalName == null ? ownerClass.getName() : canonicalName;
    }
}

