/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.proxy.MxAbstractProxy;
import com.maxifier.mxcache.proxy.MxAbstractProxyFactory;
import com.maxifier.mxcache.proxy.MxProxyGenerator;
import com.maxifier.mxcache.proxy.Resolvable;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxConstructorGenerator;
import com.maxifier.mxcache.util.MxGeneratorAdapter;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MxProxyFactory<T, C extends Resolvable<T>>
extends MxAbstractProxyFactory {
    private static final Logger logger = LoggerFactory.getLogger(MxProxyGenerator.class);
    private static final Method MX_ABSTRACT_PROXY_CTOR = new Method("<init>", Type.VOID_TYPE, new Type[]{RESOLVABLE_TYPE, CodegenHelper.CLASS_TYPE, CodegenHelper.CLASS_TYPE});
    private static final Type MX_ABSTRACT_PROXY_TYPE = Type.getType(MxAbstractProxy.class);
    private final Class<T> sourceInterface;
    private final Class<C> containerClass;
    private volatile Constructor<T> proxyConstructor;

    MxProxyFactory(@Nonnull Class<T> sourceInterface, @Nonnull Class<C> containerClass) {
        if (!sourceInterface.isInterface()) {
            throw new IllegalArgumentException("Only interface can be used as proxy source but " + sourceInterface + " was passed");
        }
        if (!Resolvable.class.isAssignableFrom(containerClass)) {
            throw new IllegalArgumentException("Container " + containerClass + " should implement " + Resolvable.class);
        }
        this.sourceInterface = sourceInterface;
        this.containerClass = containerClass;
    }

    private synchronized void initProxy() {
        if (this.proxyConstructor == null) {
            Class<T> proxyClass = MxProxyFactory.createProxyClass(this.sourceInterface, this.containerClass);
            try {
                this.proxyConstructor = proxyClass.getConstructor(this.containerClass);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Class<T> getSourceInterface() {
        return this.sourceInterface;
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public T createProxy(C container) {
        try {
            return this.getProxyConstructor().newInstance(container);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create proxy for " + container, e);
        }
    }

    private synchronized Constructor<T> getProxyConstructor() {
        if (this.proxyConstructor == null) {
            this.initProxy();
        }
        return this.proxyConstructor;
    }

    private static <T, C extends Resolvable<T>> Class<T> createProxyClass(Class<T> sourceClass, Class<C> containerClass) {
        long start = System.currentTimeMillis();
        try {
            Type containerType = Type.getType(containerClass);
            ClassGenerator proxyClass = new ClassGenerator(33, MxProxyFactory.createProxyClassName(sourceClass), MxAbstractProxy.class, sourceClass);
            MxProxyFactory.createProxyConstructor(sourceClass, containerClass, proxyClass, containerType);
            for (java.lang.reflect.Method sourceMethod : sourceClass.getMethods()) {
                MxProxyFactory.createMethodProxy(sourceClass, proxyClass, containerType, sourceMethod);
            }
            proxyClass.defineDefaultConstructor();
            Class clazz = proxyClass.toClass(sourceClass.getClassLoader());
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            long end = System.currentTimeMillis();
            logger.debug("Generated proxy for " + sourceClass + " with container " + containerClass + " in " + (end - start) + " ms");
        }
    }

    private static <T, C extends Resolvable<T>> void createProxyConstructor(Class<T> sourceClass, Class<C> containerClass, ClassGenerator generator, Type containerType) {
        MxConstructorGenerator ctor = generator.defineConstructor(1, containerType);
        ctor.start();
        ctor.loadThis();
        ctor.loadArg(0);
        ctor.push(Type.getType(sourceClass));
        ctor.push(Type.getType(containerClass));
        ctor.invokeConstructor(MX_ABSTRACT_PROXY_TYPE, MX_ABSTRACT_PROXY_CTOR);
        ctor.returnValue();
        ctor.endMethod();
    }

    private static <T> void createMethodProxy(Class<T> sourceClass, ClassGenerator cpg, Type containerType, java.lang.reflect.Method sourceMethod) {
        Method sourceMethod0 = Method.getMethod((java.lang.reflect.Method)sourceMethod);
        MxGeneratorAdapter method = cpg.defineMethod(1, sourceMethod0);
        method.start();
        method.loadThis();
        method.getField(MX_ABSTRACT_PROXY_TYPE, "value", RESOLVABLE_TYPE);
        method.checkCast(containerType);
        method.invokeVirtual(containerType, GETTER);
        for (int i = 0; i < sourceMethod.getParameterTypes().length; ++i) {
            method.loadArg(i);
        }
        method.invokeInterface(Type.getType(sourceClass), sourceMethod0);
        method.returnValue();
        method.endMethod();
    }

    public String toString() {
        return "ProxyFactory for " + this.sourceInterface + " wrapped in " + this.containerClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MxProxyFactory)) {
            return false;
        }
        MxProxyFactory that = (MxProxyFactory)o;
        return this.containerClass == that.containerClass && this.sourceInterface == that.sourceInterface;
    }

    public int hashCode() {
        return 31 * this.sourceInterface.hashCode() + this.containerClass.hashCode();
    }
}

