/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.transform.ScalarTransformGenerator;
import javax.annotation.Nonnull;

public class BoxTransformGenerator
extends ScalarTransformGenerator {
    private final Class cls;
    private final Type type;

    public BoxTransformGenerator(Class cls, @Nonnull Type type) {
        this.cls = cls;
        this.type = type;
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.box(this.type);
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.unbox(this.type);
    }

    @Override
    public Class<?> getInType() {
        return this.cls;
    }

    @Override
    public Class<?> getOutType() {
        return Object.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxTransformGenerator that = (BoxTransformGenerator)o;
        return this.type.equals((Object)that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "box " + this.type.getClassName();
    }
}

