/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.MxCacheException;
import com.maxifier.mxcache.util.CodegenHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class CompileHelper
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private Class loadedClass;

    private CompileHelper(StandardJavaFileManager fileManager) {
        super(fileManager);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject originatingSource) throws IOException {
        return new OutputJavaFileObject(name);
    }

    public static Class compile(String className, String source) throws IOException {
        final StringBuffer buffer = new StringBuffer();
        DiagnosticListener<JavaFileObject> listener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                buffer.append(diagnostic).append('\n');
            }
        };
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        CompileHelper instance = new CompileHelper(compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)listener, null, null));
        InputJavaFileObject fileObject = new InputJavaFileObject(className, source);
        JavaCompiler.CompilationTask task = compiler.getTask(null, instance, (DiagnosticListener<? super JavaFileObject>)listener, null, null, Arrays.asList(fileObject));
        if (!task.call().booleanValue()) {
            throw new MxCacheException("Cannot compile fragment <" + source + ">: " + buffer);
        }
        return instance.loadedClass;
    }

    private static URI createUri(String name, JavaFileObject.Kind kind) throws IOException {
        try {
            return new URI("mxcache:///" + name.replace('.', '/') + kind.extension);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static class InputJavaFileObject
    extends SimpleJavaFileObject {
        private final String code;

        public InputJavaFileObject(String name, String code) throws IOException {
            super(CompileHelper.createUri(name, JavaFileObject.Kind.SOURCE), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    private static class CreateClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private CreateClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return new ClassLoader(){};
        }
    }

    private class OutputJavaFileObject
    extends SimpleJavaFileObject {
        OutputJavaFileObject(String name) throws IOException {
            super(CompileHelper.createUri(name, JavaFileObject.Kind.CLASS), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    CompileHelper.this.loadedClass = CodegenHelper.loadClass(AccessController.doPrivileged(new CreateClassLoaderAction()), this.toByteArray());
                }
            };
        }
    }
}

