/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.transform.TransformGenerator;
import com.maxifier.mxcache.util.ClassGenerator;
import javax.annotation.Nonnull;

public class CompositeTransformGenerator
implements TransformGenerator {
    private final TransformGenerator forward;
    private final TransformGenerator backward;

    public CompositeTransformGenerator(@Nonnull TransformGenerator forward, @Nonnull TransformGenerator backward) {
        this.forward = forward;
        this.backward = backward;
        if (!CompositeTransformGenerator.isCompatible(forward.getOutType(), backward.getInType())) {
            throw new IllegalArgumentException("Incompatible forward and backward types: " + forward + " and " + backward);
        }
        if (!CompositeTransformGenerator.isCompatible(backward.getOutType(), forward.getInType())) {
            throw new IllegalArgumentException("Incompatible forward and backward types: " + forward + " and " + backward);
        }
    }

    private static boolean isCompatible(Class<?> out, Class<?> in) {
        return in == null ? out == null : in.isAssignableFrom(out);
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        this.forward.generateForward(thisType, fieldIndex, method);
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        this.backward.generateForward(thisType, this.forward.getFieldCount() + fieldIndex, method);
    }

    @Override
    public void generateFields(Type thisType, int fieldIndex, ClassGenerator writer) {
        this.forward.generateFields(thisType, fieldIndex, writer);
        this.backward.generateFields(thisType, this.forward.getFieldCount() + fieldIndex, writer);
    }

    @Override
    public void generateAcquire(Type thisType, int fieldIndex, GeneratorAdapter ctor, int contextLocal) {
        this.forward.generateAcquire(thisType, fieldIndex, ctor, contextLocal);
        this.backward.generateAcquire(thisType, this.forward.getFieldCount() + fieldIndex, ctor, contextLocal);
    }

    @Override
    public int getFieldCount() {
        return this.forward.getFieldCount() + this.backward.getFieldCount();
    }

    public Class getOutType() {
        return this.forward.getOutType();
    }

    public Class getInType() {
        return this.forward.getInType();
    }

    @Override
    public Signature transformKey(Signature in) {
        return this.forward.transformKey(in);
    }

    @Override
    public Signature transformValue(Signature in) {
        return this.forward.transformValue(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeTransformGenerator that = (CompositeTransformGenerator)o;
        return this.forward.equals(that.forward) && this.backward.equals(that.backward);
    }

    public int hashCode() {
        return 31 * this.forward.hashCode() + this.backward.hashCode();
    }

    public String toString() {
        return "{forward = " + this.forward + ", backward = " + this.backward + "}";
    }
}

