/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.transform.ScalarTransformGenerator;

public class UnboxTransformGenerator
extends ScalarTransformGenerator {
    private final Class cls;
    private final Type type;

    public UnboxTransformGenerator(Class cls) {
        if (!cls.isPrimitive()) {
            throw new IllegalArgumentException("Only primitives can be boxed");
        }
        this.cls = cls;
        this.type = Type.getType((Class)cls);
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.unbox(this.type);
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.box(this.type);
    }

    public Class getOutType() {
        return this.cls;
    }

    @Override
    public Class<?> getInType() {
        return Object.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnboxTransformGenerator that = (UnboxTransformGenerator)o;
        return this.cls.equals(that.cls);
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public String toString() {
        return "unbox " + this.cls.getSimpleName();
    }
}

