/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.tuple;

import com.maxifier.mxcache.asm.Label;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.tuple.Tuple;
import com.maxifier.mxcache.tuple.TupleFactory;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.Generator;
import com.maxifier.mxcache.util.MxConstructorGenerator;
import com.maxifier.mxcache.util.MxField;
import com.maxifier.mxcache.util.MxGeneratorAdapter;
import gnu.trove.map.hash.THashMap;
import gnu.trove.strategy.HashingStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class TupleGenerator {
    private static final Type FLOAT_WRAPPER_TYPE = Type.getType(Float.class);
    private static final Type DOUBLE_WRAPPER_TYPE = Type.getType(Double.class);
    private static final Type STRING_BUILDER_TYPE = Type.getType(StringBuilder.class);
    private static final Type TUPLE_TYPE = Type.getType(Tuple.class);
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION_TYPE = Type.getType(IllegalArgumentException.class);
    private static final Method EQUALS_METHOD = Method.getMethod((String)"boolean equals(Object)");
    private static final Method HASH_CODE_METHOD = Method.getMethod((String)"int hashCode()");
    private static final Method GET_METHOD = Method.getMethod((String)"java.lang.Object get(int)");
    private static final Method GET_BOOLEAN_METHOD = Method.getMethod((String)"boolean getBoolean(int)");
    private static final Method GET_BYTE_METHOD = Method.getMethod((String)"byte getByte(int)");
    private static final Method GET_CHAR_METHOD = Method.getMethod((String)"char getChar(int)");
    private static final Method GET_SHORT_METHOD = Method.getMethod((String)"short getShort(int)");
    private static final Method GET_INT_METHOD = Method.getMethod((String)"int getInt(int)");
    private static final Method GET_LONG_METHOD = Method.getMethod((String)"long getLong(int)");
    private static final Method GET_FLOAT_METHOD = Method.getMethod((String)"float getFloat(int)");
    private static final Method GET_DOUBLE_METHOD = Method.getMethod((String)"double getDouble(int)");
    private static final Method SIZE_METHOD = Method.getMethod((String)"int size()");
    private static final Method FLOAT_IS_NAN_METHOD = Method.getMethod((String)"boolean isNaN(float)");
    private static final Method DOUBLE_IS_NAN_METHOD = Method.getMethod((String)"boolean isNaN(double)");
    private static final Method FLOAT_TO_INT_BITS_METHOD = Method.getMethod((String)"int floatToIntBits(float)");
    private static final Method DOUBLE_TO_LONG_BITS_METHOD = Method.getMethod((String)"long doubleToLongBits(double)");
    private static final Method APPEND_OBJECT_METHOD = Method.getMethod((String)"java.lang.StringBuilder append(java.lang.Object)");
    private static final Method APPEND_INT_METHOD = Method.getMethod((String)"java.lang.StringBuilder append(int)");
    private static final Method INIT_EXCEPTION_METHOD = Method.getMethod((String)"void <init>(String)");
    public static final Method TUPLE_GET_HASHING_STRATEGIES = Method.getMethod((String)"gnu.trove.strategy.HashingStrategy[] getHashingStrategies()");
    private static final THashMap<String, TupleClass> CACHE = new THashMap();
    private static final Type HASHING_STRATEGY_TYPE = Type.getType(HashingStrategy.class);
    private static final Type HASHING_STRATEGY_ARRAY_TYPE = Type.getType(HashingStrategy[].class);
    private static final int INT_BITS = 32;
    private static final int TRUE_HASHCODE = Boolean.TRUE.hashCode();
    private static final int FALSE_HASHCODE = Boolean.FALSE.hashCode();
    private static final Method EQUALS_OBJECT_OBJECT_METHOD = Method.getMethod((String)"boolean equals(Object, Object)");
    private static final Method COMPUTE_HASH_CODE_METHOD = Method.getMethod((String)"int computeHashCode(Object)");
    private static final String HASHING_STRATEGIES_FIELD = "hashingStrategies";
    private static final Generator[][] CONVERTERS = new Generator[9][9];

    private TupleGenerator() {
    }

    public static Class<Tuple> getTupleClass(Class ... values) {
        return TupleGenerator.getTupleClass0(CodegenHelper.toErasedTypes(values)).getRealClass();
    }

    public static Class<Tuple> getTupleClass(Type ... values) {
        return TupleGenerator.getTupleClass0(CodegenHelper.erase(values)).getRealClass();
    }

    public static String getTupleClassName(Type ... values) {
        return TupleGenerator.generateTupleClassName(CodegenHelper.erase(values));
    }

    public static TupleFactory createTupleFactory(HashingStrategy[] hashingStrategies, Class ... types) {
        return TupleGenerator.getTupleClass0(CodegenHelper.toErasedTypes(types)).createFactory(hashingStrategies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TupleClass getTupleClass0(Type ... types) {
        String tupleClassName = TupleGenerator.generateTupleClassName(types);
        THashMap<String, TupleClass> tHashMap = CACHE;
        synchronized (tHashMap) {
            TupleClass tupleClass = (TupleClass)CACHE.get((Object)tupleClassName);
            if (tupleClass == null) {
                tupleClass = new TupleClass(TupleGenerator.generateTupleClass(tupleClassName, types));
                CACHE.put((Object)tupleClassName, (Object)tupleClass);
            }
            return tupleClass;
        }
    }

    private static Class<Tuple> generateTupleClass(String tupleClassName, Type[] types) {
        return CodegenHelper.loadClass(Tuple.class.getClassLoader(), TupleGenerator.generateTupleClassBytecode(tupleClassName, types));
    }

    private static byte[] generateTupleClassBytecode(String tupleClassName, Type[] types) {
        ClassGenerator classWriter = new ClassGenerator(4129, tupleClassName, TUPLE_TYPE, new Type[0]);
        Type tupleType = classWriter.getThisType();
        MxField[] fields = new MxField[types.length];
        for (int i = 0; i < types.length; ++i) {
            MxField field = classWriter.defineField(17, "$" + i, types[i]);
            classWriter.defineGetter(field, "getElement" + i);
            fields[i] = field;
        }
        TupleGenerator.generateConstructor(types, classWriter, fields);
        TupleGenerator.generateGet(types, tupleType, classWriter.defineMethod(1, GET_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.BOOLEAN_TYPE, classWriter.defineMethod(1, GET_BOOLEAN_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.BYTE_TYPE, classWriter.defineMethod(1, GET_BYTE_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.CHAR_TYPE, classWriter.defineMethod(1, GET_CHAR_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.SHORT_TYPE, classWriter.defineMethod(1, GET_SHORT_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.INT_TYPE, classWriter.defineMethod(1, GET_INT_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.LONG_TYPE, classWriter.defineMethod(1, GET_LONG_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.FLOAT_TYPE, classWriter.defineMethod(1, GET_FLOAT_METHOD));
        TupleGenerator.generateGetPrimitive(types, tupleType, Type.DOUBLE_TYPE, classWriter.defineMethod(1, GET_DOUBLE_METHOD));
        TupleGenerator.generateSize(types, classWriter.defineMethod(1, SIZE_METHOD));
        TupleGenerator.generateHashCode(types, tupleType, classWriter.defineMethod(1, HASH_CODE_METHOD));
        TupleGenerator.generateEquals(types, tupleType, classWriter.defineMethod(1, EQUALS_METHOD));
        TupleGenerator.generateToString(types, tupleType, classWriter.defineMethod(1, MxGeneratorAdapter.TO_STRING_METHOD));
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void generateConstructor(Type[] types, ClassGenerator classWriter, MxField[] fields) {
        Type hashingStrategiesType;
        Type[] ctorArgTypes = new Type[types.length + 1];
        System.arraycopy(types, 0, ctorArgTypes, 1, types.length);
        ctorArgTypes[0] = hashingStrategiesType = Type.getType(HashingStrategy[].class);
        MxConstructorGenerator ctor = classWriter.defineConstructor(1, ctorArgTypes);
        ctor.callSuper(hashingStrategiesType);
        ctor.initFields(fields);
        ctor.returnValue();
        ctor.endMethod();
    }

    private static void generateSize(Type[] types, MxGeneratorAdapter visitor) {
        visitor.start();
        visitor.push(types.length);
        visitor.returnValue();
        visitor.endMethod();
    }

    private static void generateEquals(Type[] types, Type tupleType, MxGeneratorAdapter visitor) {
        Label equal = new Label();
        Label notEqual = new Label();
        Label end = new Label();
        visitor.start();
        visitor.loadThis();
        visitor.loadArg(0);
        visitor.ifCmp(CodegenHelper.OBJECT_TYPE, 153, equal);
        visitor.loadArg(0);
        visitor.instanceOf(tupleType);
        visitor.ifZCmp(153, notEqual);
        visitor.loadArg(0);
        visitor.checkCast(tupleType);
        int other = visitor.newLocal(tupleType);
        visitor.storeLocal(other);
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            Label next = new Label();
            if (CodegenHelper.isReferenceType(type)) {
                Label defaultEquals = new Label();
                visitor.loadThis();
                visitor.getField(tupleType, HASHING_STRATEGIES_FIELD, HASHING_STRATEGY_ARRAY_TYPE);
                visitor.push(i);
                visitor.arrayLoad(HASHING_STRATEGY_TYPE);
                visitor.dup();
                visitor.ifNull(defaultEquals);
                visitor.loadThis();
                visitor.getField(tupleType, "$" + i, type);
                visitor.loadLocal(other);
                visitor.getField(tupleType, "$" + i, type);
                visitor.invokeInterface(HASHING_STRATEGY_TYPE, EQUALS_OBJECT_OBJECT_METHOD);
                visitor.ifZCmp(153, notEqual);
                visitor.goTo(next);
                visitor.mark(defaultEquals);
                visitor.pop();
            } else {
                visitor.loadThis();
                visitor.getField(tupleType, HASHING_STRATEGIES_FIELD, HASHING_STRATEGY_ARRAY_TYPE);
                visitor.push(i);
                visitor.arrayLoad(HASHING_STRATEGY_TYPE);
                Label ok = new Label();
                visitor.ifNull(ok);
                visitor.throwException(ILLEGAL_ARGUMENT_EXCEPTION_TYPE, "Primitives don't support hashing strategy: " + i + "th param of type " + type.getClassName());
                visitor.mark(ok);
            }
            visitor.loadThis();
            visitor.getField(tupleType, "$" + i, type);
            visitor.loadLocal(other);
            visitor.getField(tupleType, "$" + i, type);
            TupleGenerator.generateEquals(visitor, type, notEqual);
            visitor.mark(next);
        }
        visitor.mark(equal);
        visitor.push(true);
        visitor.goTo(end);
        visitor.mark(notEqual);
        visitor.push(false);
        visitor.mark(end);
        visitor.returnValue();
        visitor.endMethod();
    }

    private static void generateEquals(MxGeneratorAdapter visitor, Type type, Label notEqual) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                TupleGenerator.generateObjectEquals(visitor, notEqual);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                visitor.ifCmp(type, 154, notEqual);
                break;
            }
            case 6: {
                TupleGenerator.generateFPEquals(visitor, notEqual, Type.FLOAT_TYPE, FLOAT_WRAPPER_TYPE);
                break;
            }
            case 8: {
                TupleGenerator.generateFPEquals(visitor, notEqual, Type.DOUBLE_TYPE, DOUBLE_WRAPPER_TYPE);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + type);
            }
        }
    }

    private static void generateFPEquals(MxGeneratorAdapter visitor, Label notEqual, Type type, Type wrapper) {
        assert (type.getSort() == 6 || type.getSort() == 8);
        boolean isDouble = type.getSize() == 2;
        Label isNotNaN = new Label();
        Label end = new Label();
        visitor.dup(type);
        visitor.invokeStatic(wrapper, isDouble ? DOUBLE_IS_NAN_METHOD : FLOAT_IS_NAN_METHOD);
        visitor.ifZCmp(153, isNotNaN);
        visitor.pop(type);
        visitor.invokeStatic(wrapper, isDouble ? DOUBLE_IS_NAN_METHOD : FLOAT_IS_NAN_METHOD);
        visitor.ifZCmp(154, end);
        visitor.goTo(notEqual);
        visitor.mark(isNotNaN);
        visitor.ifCmp(type, 154, notEqual);
        visitor.mark(end);
    }

    private static void generateObjectEquals(MxGeneratorAdapter visitor, Label notEqual) {
        Label isNull = new Label();
        Label endLabel = new Label();
        visitor.dup();
        visitor.ifNull(isNull);
        visitor.swap();
        visitor.invokeVirtual(CodegenHelper.OBJECT_TYPE, EQUALS_METHOD);
        visitor.ifZCmp(153, notEqual);
        visitor.goTo(endLabel);
        visitor.mark(isNull);
        visitor.pop();
        visitor.ifNonNull(notEqual);
        visitor.mark(endLabel);
    }

    private static void generateHashCode(Type[] types, Type tupleType, MxGeneratorAdapter visitor) {
        visitor.start();
        visitor.push(31);
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            if (i != 0) {
                visitor.push(31);
                visitor.visitInsn(104);
            }
            Label next = new Label();
            if (CodegenHelper.isReferenceType(type)) {
                Label defaultHashCode = new Label();
                visitor.loadThis();
                visitor.getField(tupleType, HASHING_STRATEGIES_FIELD, HASHING_STRATEGY_ARRAY_TYPE);
                visitor.push(i);
                visitor.arrayLoad(HASHING_STRATEGY_TYPE);
                visitor.dup();
                visitor.ifNull(defaultHashCode);
                visitor.loadThis();
                visitor.getField(tupleType, "$" + i, type);
                visitor.invokeInterface(HASHING_STRATEGY_TYPE, COMPUTE_HASH_CODE_METHOD);
                visitor.goTo(next);
                visitor.mark(defaultHashCode);
                visitor.pop();
            } else {
                visitor.loadThis();
                visitor.getField(tupleType, HASHING_STRATEGIES_FIELD, HASHING_STRATEGY_ARRAY_TYPE);
                visitor.push(i);
                visitor.arrayLoad(HASHING_STRATEGY_TYPE);
                Label ok = new Label();
                visitor.ifNull(ok);
                visitor.throwException(ILLEGAL_ARGUMENT_EXCEPTION_TYPE, "No strategy expected for " + i + "th param of type " + type.getClassName());
                visitor.mark(ok);
            }
            visitor.loadThis();
            visitor.getField(tupleType, "$" + i, type);
            TupleGenerator.generateHashCode(visitor, type);
            visitor.mark(next);
            visitor.visitInsn(96);
        }
        visitor.returnValue();
        visitor.endMethod();
    }

    private static void generateHashCode(MxGeneratorAdapter visitor, Type type) {
        switch (type.getSort()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return;
            }
            case 1: {
                TupleGenerator.generateBooleanHashCode(visitor);
                return;
            }
            case 6: {
                visitor.invokeStatic(FLOAT_WRAPPER_TYPE, FLOAT_TO_INT_BITS_METHOD);
                return;
            }
            case 8: {
                visitor.invokeStatic(DOUBLE_WRAPPER_TYPE, DOUBLE_TO_LONG_BITS_METHOD);
                TupleGenerator.generateLongHashCode(visitor);
                return;
            }
            case 7: {
                TupleGenerator.generateLongHashCode(visitor);
                return;
            }
            case 9: 
            case 10: {
                TupleGenerator.generateObjectHashCode(visitor);
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + type);
    }

    private static void generateObjectHashCode(MxGeneratorAdapter visitor) {
        Label labelNull = new Label();
        Label labelEnd = new Label();
        visitor.dup();
        visitor.ifNull(labelNull);
        visitor.invokeVirtual(CodegenHelper.OBJECT_TYPE, HASH_CODE_METHOD);
        visitor.goTo(labelEnd);
        visitor.mark(labelNull);
        visitor.pop();
        visitor.push(0);
        visitor.mark(labelEnd);
    }

    private static void generateBooleanHashCode(MxGeneratorAdapter visitor) {
        Label labelFalse = new Label();
        Label next = new Label();
        visitor.ifZCmp(153, labelFalse);
        visitor.push(TRUE_HASHCODE);
        visitor.goTo(next);
        visitor.mark(labelFalse);
        visitor.push(FALSE_HASHCODE);
        visitor.mark(next);
    }

    private static void generateLongHashCode(MxGeneratorAdapter visitor) {
        visitor.dup2();
        visitor.push(32);
        visitor.visitInsn(125);
        visitor.visitInsn(131);
        visitor.cast(Type.LONG_TYPE, Type.INT_TYPE);
    }

    private static void generateToString(Type[] types, Type tupleType, MxGeneratorAdapter visitor) {
        visitor.start();
        visitor.createWithDefaultConstructor(STRING_BUILDER_TYPE);
        String s = TupleGenerator.getTupleName(types) + "(";
        TupleGenerator.generateConstAppend(visitor, s);
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            visitor.loadThis();
            visitor.getField(tupleType, "$" + i, type);
            TupleGenerator.generateAppend(visitor, type);
            if (i >= types.length - 1) continue;
            TupleGenerator.generateConstAppend(visitor, ", ");
        }
        TupleGenerator.generateConstAppend(visitor, ")");
        visitor.invokeToString();
        visitor.returnValue();
        visitor.endMethod();
    }

    private static void generateConstAppend(MxGeneratorAdapter visitor, String s) {
        visitor.push(s);
        TupleGenerator.generateObjectAppend(visitor);
    }

    private static void generateAppend(MxGeneratorAdapter visitor, Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                TupleGenerator.generateObjectAppend(visitor);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                TupleGenerator.generateIntAppend(visitor);
                break;
            }
            default: {
                visitor.invokeVirtual(STRING_BUILDER_TYPE, new Method("append", STRING_BUILDER_TYPE, new Type[]{type}));
            }
        }
    }

    private static void generateIntAppend(MxGeneratorAdapter visitor) {
        visitor.invokeVirtual(STRING_BUILDER_TYPE, APPEND_INT_METHOD);
    }

    private static void generateObjectAppend(MxGeneratorAdapter visitor) {
        visitor.invokeVirtual(STRING_BUILDER_TYPE, APPEND_OBJECT_METHOD);
    }

    private static String getTupleName(Type[] types) {
        StringBuilder b = new StringBuilder("Tuple<");
        for (Type type : types) {
            b.append(type.getClassName()).append(", ");
        }
        b.setLength(b.length() - 2);
        b.append(">");
        return b.toString();
    }

    private static void generateGet(Type[] types, Type tupleType, MxGeneratorAdapter visitor) {
        visitor.start();
        Label[] labels = TupleGenerator.createLabels(types.length);
        Label invalidArgument = new Label();
        visitor.loadArg(0);
        visitor.visitTableSwitchInsn(0, types.length - 1, invalidArgument, labels);
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            visitor.mark(labels[i]);
            visitor.loadThis();
            visitor.getField(tupleType, "$" + i, type);
            visitor.valueOf(type);
            visitor.returnValue();
        }
        visitor.mark(invalidArgument);
        TupleGenerator.generateInvalidTupleIndex(visitor);
        visitor.endMethod();
    }

    private static void addCast(Type from, Type to) {
        TupleGenerator.CONVERTERS[from.getSort()][to.getSort()] = new CastConverter(from, to);
    }

    private static void generateGetPrimitive(Type[] types, Type tupleType, Type primType, MxGeneratorAdapter visitor) {
        Type type;
        int i;
        visitor.start();
        Label invalidArgument = new Label();
        visitor.loadArg(0);
        Label[] labels = new Label[types.length];
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            labels[i] = type == primType || type.getSort() <= 8 && CONVERTERS[type.getSort()][primType.getSort()] != null ? new Label() : invalidArgument;
        }
        visitor.visitTableSwitchInsn(0, types.length - 1, invalidArgument, labels);
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (type == primType) {
                visitor.mark(labels[i]);
                visitor.loadThis();
                visitor.getField(tupleType, "$" + i, type);
                visitor.returnValue();
                continue;
            }
            if (type.getSort() <= 8) {
                Generator c = CONVERTERS[type.getSort()][primType.getSort()];
                if (c != null) {
                    visitor.mark(labels[i]);
                    visitor.loadThis();
                    visitor.getField(tupleType, "$" + i, type);
                    c.generate(visitor);
                    visitor.returnValue();
                    continue;
                }
                assert (labels[i] == invalidArgument);
                continue;
            }
            assert (labels[i] == invalidArgument);
        }
        visitor.mark(invalidArgument);
        TupleGenerator.generateInvalidTupleIndex(visitor);
        visitor.endMethod();
    }

    private static Label[] createLabels(int n) {
        Label[] labels = new Label[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = new Label();
        }
        return labels;
    }

    private static void generateInvalidTupleIndex(MxGeneratorAdapter visitor) {
        visitor.newInstance(ILLEGAL_ARGUMENT_EXCEPTION_TYPE);
        visitor.dup();
        TupleGenerator.generateInvalidArgumentMessage(visitor);
        visitor.invokeConstructor(ILLEGAL_ARGUMENT_EXCEPTION_TYPE, INIT_EXCEPTION_METHOD);
        visitor.throwException();
    }

    private static void generateInvalidArgumentMessage(MxGeneratorAdapter visitor) {
        visitor.createWithDefaultConstructor(STRING_BUILDER_TYPE);
        TupleGenerator.generateConstAppend(visitor, "Tuple ");
        visitor.loadThis();
        TupleGenerator.generateObjectAppend(visitor);
        TupleGenerator.generateConstAppend(visitor, " doesn't contain element with index ");
        visitor.loadArg(0);
        TupleGenerator.generateIntAppend(visitor);
        visitor.invokeToString();
    }

    private static String generateTupleClassName(Type[] types) {
        StringBuilder b = new StringBuilder(TUPLE_TYPE.getInternalName()).append("$");
        for (Type type : types) {
            if (CodegenHelper.isReferenceType(type)) {
                b.append('A');
                continue;
            }
            b.append(type.getDescriptor());
        }
        return b.toString();
    }

    static {
        TupleGenerator.addCast(Type.BYTE_TYPE, Type.CHAR_TYPE);
        TupleGenerator.addCast(Type.BYTE_TYPE, Type.SHORT_TYPE);
        TupleGenerator.addCast(Type.BYTE_TYPE, Type.INT_TYPE);
        TupleGenerator.addCast(Type.BYTE_TYPE, Type.LONG_TYPE);
        TupleGenerator.addCast(Type.SHORT_TYPE, Type.CHAR_TYPE);
        TupleGenerator.addCast(Type.SHORT_TYPE, Type.INT_TYPE);
        TupleGenerator.addCast(Type.SHORT_TYPE, Type.LONG_TYPE);
        TupleGenerator.addCast(Type.CHAR_TYPE, Type.SHORT_TYPE);
        TupleGenerator.addCast(Type.CHAR_TYPE, Type.INT_TYPE);
        TupleGenerator.addCast(Type.CHAR_TYPE, Type.LONG_TYPE);
        TupleGenerator.addCast(Type.INT_TYPE, Type.LONG_TYPE);
        TupleGenerator.addCast(Type.FLOAT_TYPE, Type.DOUBLE_TYPE);
    }

    private static class CastConverter
    extends Generator {
        private final Type from;
        private final Type to;

        public CastConverter(Type from, Type to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void generate(MxGeneratorAdapter mv) {
            mv.cast(this.from, this.to);
        }
    }

    private static class TupleFactoryImpl
    implements TupleFactory {
        private final Constructor<? extends Tuple> ctor;
        private final HashingStrategy[] hs;

        TupleFactoryImpl(HashingStrategy[] hs, Constructor<? extends Tuple> ctor) {
            this.hs = hs;
            this.ctor = ctor;
        }

        @Override
        public Tuple create(Object ... values) {
            try {
                Object[] args = new Object[values.length + 1];
                System.arraycopy(values, 0, args, 1, values.length);
                args[0] = this.hs;
                return this.ctor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Class<? extends Tuple> getTupleClass() {
            return this.ctor.getDeclaringClass();
        }
    }

    private static class TupleClass {
        private final Class<Tuple> realClass;

        public TupleClass(Class<Tuple> realClass) {
            this.realClass = realClass;
        }

        public Class<Tuple> getRealClass() {
            return this.realClass;
        }

        public synchronized TupleFactory createFactory(HashingStrategy[] hashingStrategies) {
            Constructor<?>[] ctors = this.realClass.getDeclaredConstructors();
            if (ctors.length != 1) {
                throw new IllegalStateException("No constructor for " + this.realClass);
            }
            return new TupleFactoryImpl(hashingStrategies, ctors[0]);
        }
    }
}

