/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import javax.annotation.Nonnull;

public class HashSoftReference<T>
extends SoftReference<T> {
    private int hashCode;

    public HashSoftReference(@Nonnull T referent) {
        super(referent);
        this.hashCode = this.hashCode(referent);
    }

    private int hashCode(T referent) {
        return referent == null ? 0 : referent.hashCode();
    }

    public HashSoftReference(T referent, ReferenceQueue<T> q) {
        super(referent, q);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        HashSoftReference that = (HashSoftReference)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        Object thisObject = this.get();
        if (thisObject == null) {
            return false;
        }
        Object thatObject = that.get();
        return thatObject != null && thisObject.equals(thatObject);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        Object v = this.get();
        if (v == null) {
            return "SoftReference<GCed>";
        }
        return "SoftReference<" + v + ">";
    }
}

