/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;

public class HashWeakReference<T>
extends WeakReference<T> {
    private int hashCode;

    public HashWeakReference(@Nonnull T referent) {
        super(referent);
        this.hashCode = this.hashCode(referent);
    }

    private int hashCode(T referent) {
        return referent == null ? 0 : referent.hashCode();
    }

    public HashWeakReference(T referent, ReferenceQueue<T> q) {
        super(referent, q);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        HashWeakReference that = (HashWeakReference)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        Object thisObject = this.get();
        if (thisObject == null) {
            return false;
        }
        Object thatObject = that.get();
        return thatObject != null && thisObject.equals(thatObject);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        Object v = this.get();
        if (v == null) {
            return "WeakReference<GCed>";
        }
        return "WeakReference<" + v + ">";
    }
}

