/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.util;

import com.maxifier.mxcache.asm.ClassVisitor;
import com.maxifier.mxcache.asm.Type;

public class MxField {
    private final int access;
    private final Type owner;
    private final String name;
    private final Type type;

    public MxField(int access, Type owner, String name, Type type) {
        this.access = access;
        this.owner = owner;
        this.name = name;
        this.type = type;
    }

    public int getAccess() {
        return this.access;
    }

    public Type getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void define(ClassVisitor v) {
        v.visitField(this.access, this.name, this.type.getDescriptor(), null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MxField mxField = (MxField)o;
        return this.access == mxField.access && this.name.equals(mxField.name) && this.owner.equals((Object)mxField.owner) && this.type.equals((Object)mxField.type);
    }

    public int hashCode() {
        int result = this.access;
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }
}

