/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator;

import com.metaobjects.MetaData;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.io.MetaDataIO;
import com.metaobjects.io.MetaDataIOException;
import com.metaobjects.util.ErrorFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GeneratorIOException
extends MetaDataIOException {
    private final GeneratorIOWriter writer;
    private final Map<String, Object> context;

    public GeneratorIOException(GeneratorIOWriter writer, String msg) {
        super((MetaDataIO)writer, msg);
        this.writer = writer;
        this.context = Map.of("errorType", "generatorIO");
    }

    public GeneratorIOException(GeneratorIOWriter writer, String msg, Exception e) {
        super((MetaDataIO)writer, msg, e);
        this.writer = writer;
        this.context = Map.of("errorType", "generatorIO", "causedBy", e.getClass().getSimpleName());
    }

    public GeneratorIOException(GeneratorIOWriter writer, String message, MetaData source, String operation, Map<String, Object> additionalContext) {
        super((MetaDataIO)writer, GeneratorIOException.buildEnhancedMessage(message, source, operation, additionalContext));
        this.writer = writer;
        HashMap<String, Object> combinedContext = new HashMap<String, Object>();
        combinedContext.put("errorType", "generatorIO");
        combinedContext.put("operation", operation);
        if (source != null) {
            combinedContext.put("sourceName", source.getName());
            combinedContext.put("sourceType", source.getType());
        }
        if (additionalContext != null) {
            combinedContext.putAll(additionalContext);
        }
        this.context = Collections.unmodifiableMap(combinedContext);
    }

    public static GeneratorIOException forFileWrite(GeneratorIOWriter writer, String fileName, MetaData source, Exception cause) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"fileWrite", (String)String.format("Failed to write file: %s", fileName), Map.of("fileName", fileName));
        return new GeneratorIOException(writer, message, source, "fileWrite", Map.of("fileName", fileName, "ioOperation", "write"));
    }

    public static GeneratorIOException forTemplateRead(GeneratorIOWriter writer, String templatePath, MetaData source, Exception cause) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"templateRead", (String)String.format("Failed to read template: %s", templatePath), Map.of("templatePath", templatePath));
        return new GeneratorIOException(writer, message, source, "templateRead", Map.of("templatePath", templatePath, "ioOperation", "read"));
    }

    public static GeneratorIOException forDirectoryCreation(GeneratorIOWriter writer, String directoryPath, MetaData source, Exception cause) {
        String message = ErrorFormatter.formatGenericError((MetaData)source, (String)"directoryCreation", (String)String.format("Failed to create directory: %s", directoryPath), Map.of("directoryPath", directoryPath));
        return new GeneratorIOException(writer, message, source, "directoryCreation", Map.of("directoryPath", directoryPath, "ioOperation", "createDirectory"));
    }

    private static String buildEnhancedMessage(String message, MetaData source, String operation, Map<String, Object> context) {
        StringBuilder enhanced = new StringBuilder();
        enhanced.append(message);
        if (source != null || operation != null || context != null && !context.isEmpty()) {
            enhanced.append("\n\n--- Generator I/O Error Details ---");
            if (source != null) {
                enhanced.append("\nMetaData: ").append(source.getName());
                enhanced.append(" (").append(source.getType()).append(")");
            }
            if (operation != null) {
                enhanced.append("\nI/O Operation: ").append(operation);
            }
            if (context != null && !context.isEmpty()) {
                enhanced.append("\nContext:");
                context.forEach((key, value) -> enhanced.append("\n  ").append((String)key).append(": ").append(value));
            }
        }
        return enhanced.toString();
    }

    public GeneratorIOWriter getGeneratorWriter() {
        return this.writer;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public Object getContextValue(String key) {
        return this.context.get(key);
    }

    public boolean hasEnhancedContext() {
        return this.context.size() > 1;
    }
}

