/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.file.xsd;

import com.metaobjects.generator.GeneratorException;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.file.xsd.MetaDataFileXSDWriter;
import com.metaobjects.generator.direct.metadata.xml.SingleXMLDirectGeneratorBase;
import com.metaobjects.generator.direct.metadata.xml.XMLDirectWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.MetaDataRegistry;
import java.io.OutputStream;

public class MetaDataFileXSDGenerator
extends SingleXMLDirectGeneratorBase {
    public static final String ARG_NAMESPACE = "nameSpace";
    public static final String ARG_TARGET_NAMESPACE = "targetNamespace";
    public static final String ARG_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    private String nameSpace = null;
    private String targetNamespace = null;
    private String elementFormDefault = "qualified";
    public static final String XSD_NAMESPACE = "xsdNamespace";
    public static final String XSD_TARGET_NAMESPACE = "xsdTargetNamespace";
    public static final String XSD_ELEMENT_FORM_DEFAULT = "xsdElementFormDefault";
    public static final String XSD_ELEMENT_NAME = "xsdElementName";
    public static final String XSD_TYPE_NAME = "xsdTypeName";

    @Override
    protected void parseArgs() {
        if (!this.hasArg(ARG_NAMESPACE)) {
            throw new GeneratorException("nameSpace argument is required");
        }
        this.nameSpace = this.getArg(ARG_NAMESPACE);
        this.targetNamespace = this.hasArg(ARG_TARGET_NAMESPACE) ? this.getArg(ARG_TARGET_NAMESPACE) : this.nameSpace;
        if (this.hasArg(ARG_ELEMENT_FORM_DEFAULT)) {
            this.elementFormDefault = this.getArg(ARG_ELEMENT_FORM_DEFAULT);
        }
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
        }
    }

    @Override
    protected XMLDirectWriter getWriter(MetaDataLoader loader, OutputStream os) throws GeneratorIOException {
        return new MetaDataFileXSDWriter(loader, os).withNamespace(this.nameSpace).withTargetNamespace(this.targetNamespace).withElementFormDefault(this.elementFormDefault);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("args=").append(this.getArgs());
        sb.append(", filters=").append(this.getFilters());
        sb.append(", nameSpace=").append(this.nameSpace);
        sb.append(", targetNamespace=").append(this.targetNamespace);
        sb.append(", elementFormDefault=").append(this.elementFormDefault);
        sb.append('}');
        return sb.toString();
    }

    public static void registerXSDAttributes(MetaDataRegistry registry) {
        registry.findType("object", "base").optionalAttribute(XSD_NAMESPACE, "string").optionalAttribute(XSD_TARGET_NAMESPACE, "string").optionalAttribute(XSD_ELEMENT_FORM_DEFAULT, "string");
        registry.findType("object", "pojo").optionalAttribute(XSD_ELEMENT_NAME, "string").optionalAttribute(XSD_TYPE_NAME, "string");
        registry.findType("field", "base").optionalAttribute(XSD_ELEMENT_NAME, "string").optionalAttribute(XSD_TYPE_NAME, "string");
        registry.findType("field", "string").optionalAttribute(XSD_ELEMENT_NAME, "string");
    }
}

