/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.html;

import com.metaobjects.generator.GeneratorException;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.MetaDataFilters;
import com.metaobjects.generator.direct.DirectGeneratorBase;
import com.metaobjects.generator.direct.metadata.html.MetaDataHtmlDocumentationWriter;
import com.metaobjects.loader.MetaDataLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class SingleHtmlDirectGeneratorBase
extends DirectGeneratorBase {
    @Override
    public void execute(MetaDataLoader loader) {
        File outf = null;
        OutputStream fos = null;
        MetaDataHtmlDocumentationWriter writer = null;
        this.parseArgs();
        try {
            outf = new File(this.getOutputDir(), this.getOutputFilename());
            outf.createNewFile();
            fos = new FileOutputStream(outf);
            writer = this.getWriter(loader, fos);
            ((MetaDataHtmlDocumentationWriter)((Object)writer.withFilename(outf.toString()))).withFilters(MetaDataFilters.create(this.getFilters()));
            this.writeHtml(writer);
        }
        catch (IOException e) {
            throw new GeneratorException("Unable to write to HTML file [" + String.valueOf(outf) + "]: " + String.valueOf(e), e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                } else if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                log.error("Error closing HTML file [" + String.valueOf(outf) + "]: " + String.valueOf(e), (Throwable)e);
            }
        }
    }

    protected abstract MetaDataHtmlDocumentationWriter getWriter(MetaDataLoader var1, OutputStream var2) throws GeneratorIOException;

    protected void writeHtml(MetaDataHtmlDocumentationWriter writer) throws GeneratorIOException {
        log.info("Writing HTML file: " + writer.getFilename());
        writer.writeHtml();
    }
}

