/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.object.javacode;

import com.metaobjects.DataTypes;
import com.metaobjects.field.MetaField;
import com.metaobjects.generator.direct.GenerationContext;
import com.metaobjects.generator.direct.object.BaseObjectCodeWriter;
import com.metaobjects.generator.util.GeneratorUtil;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.object.MetaObject;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class JavaCodeWriter
extends BaseObjectCodeWriter {
    public static final String ATTR_JAVANAME = "javaName";

    public JavaCodeWriter(MetaDataLoader loader, PrintWriter pw) {
        super(loader, pw);
    }

    public JavaCodeWriter(MetaDataLoader loader, PrintWriter pw, GenerationContext context) {
        super(loader, pw, context);
    }

    @Override
    protected String getLanguageType(MetaField field) {
        MetaObject mo = (MetaObject)this.objectReferenceMap.get(field);
        if (mo != null) {
            Object typeName = this.getClassName(mo);
            String pre = (String)this.pkgPrefixMap.get(mo);
            if (pre != null) {
                typeName = pre + (String)typeName;
            }
            if (field.getDataType().isArray()) {
                typeName = "java.util.List<" + (String)typeName + ">";
            }
            return typeName;
        }
        switch (field.getDataType()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTE: {
                return "Byte";
            }
            case SHORT: {
                return "Short";
            }
            case INT: {
                return "Integer";
            }
            case LONG: {
                return "Long";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case DATE: {
                return "java.util.Date";
            }
            case STRING: {
                return "String";
            }
            case STRING_ARRAY: {
                return "java.util.List<String>";
            }
            case OBJECT: {
                return "Object";
            }
            case OBJECT_ARRAY: {
                return "java.util.List<Object>";
            }
        }
        return "Object";
    }

    @Override
    protected String getGetterMethodName(MetaField field) {
        String name = field.getName();
        String languageAttr = this.getLanguageNameAttribute();
        if (field.hasMetaAttr(languageAttr)) {
            name = field.getMetaAttr(languageAttr).getValueAsString();
        }
        String prefix = "get";
        if (field.getDataType() == DataTypes.BOOLEAN) {
            prefix = "is";
        }
        return prefix + GeneratorUtil.toCamelCase(name, true);
    }

    @Override
    protected String getSetterMethodName(MetaField field) {
        String name = field.getName();
        String languageAttr = this.getLanguageNameAttribute();
        if (field.hasMetaAttr(languageAttr)) {
            name = field.getMetaAttr(languageAttr).getValueAsString();
        }
        return "set" + GeneratorUtil.toCamelCase(name, true);
    }

    @Override
    protected String getParameterName(MetaField field) {
        return GeneratorUtil.toCamelCase(field.getName(), false);
    }

    @Override
    protected String getClassName(MetaObject mo) {
        Object name = mo.getShortName();
        if (this.isNotBlank(this.namePrefix)) {
            name = this.namePrefix + "-" + (String)name;
        }
        if (this.isNotBlank(this.nameSuffix)) {
            name = (String)name + "-" + this.nameSuffix;
        }
        name = ((String)name).replaceAll("--", "-");
        return GeneratorUtil.toCamelCase((String)name, true);
    }

    @Override
    protected void writeGetter(String getterName, String typeName, MetaField field) {
        if (!this.type.equals("interface")) {
            throw new UnsupportedOperationException("Cannot draw method [" + getterName + "] for type [" + this.type + "]");
        }
        this.println(true, "/**");
        this.println(true, " * " + getterName + " is a code generated Getter method");
        this.println(true, " * @returns " + typeName + " Value to get");
        this.println(true, " */");
        this.println(true, "public " + typeName + " " + getterName + "();");
    }

    @Override
    protected void writeSetter(String setterName, String paramName, String typeName, MetaField field) {
        if (!this.type.equals("interface")) {
            throw new UnsupportedOperationException("Cannot draw method [" + setterName + "] for type [" + this.type + "]");
        }
        this.println(true, "/**");
        this.println(true, " * " + setterName + " is a code generated Setter method");
        this.println(true, " * @param " + paramName + " Value to set");
        this.println(true, " */");
        this.println(true, "public void " + setterName + "(" + typeName + " " + paramName + ");");
    }

    @Override
    protected void writeObjectHeader(List<String> docs, String pkg, String name, List<String> importList, String fullSuperName) {
        this.println("package " + pkg + ";");
        if (!importList.isEmpty()) {
            this.println();
            TreeSet<String> uniqueImports = new TreeSet<String>(importList);
            Iterator iterator = uniqueImports.iterator();
            while (iterator.hasNext()) {
                String imp = (String)iterator.next();
                this.println("import " + imp + ";");
            }
        }
        this.println();
        this.println("/**");
        for (String doc : docs) {
            this.println(" * " + doc);
        }
        this.println(" */");
        String extendsClause = fullSuperName != null && !fullSuperName.isEmpty() ? " extends " + fullSuperName : "";
        this.println("public " + this.type + " " + name + extendsClause + " {");
    }

    @Override
    protected void writeObjectFooter() {
        this.println();
        this.println("}");
        this.println();
    }

    @Override
    protected void writeComment(String comment) {
        this.println(true, "// " + comment);
    }

    @Override
    protected void writeNewLine() {
        this.println();
    }

    @Override
    protected String getLanguagePackage(MetaObject mo) {
        Object path = mo.getPackage().replaceAll("::", ".");
        if (this.isNotBlank(this.pkgPrefix)) {
            path = this.pkgPrefix.endsWith(".") ? this.pkgPrefix + (String)path : this.pkgPrefix + "." + (String)path;
        }
        if (this.isNotBlank(this.pkgSuffix)) {
            path = this.pkgSuffix.startsWith(".") ? (String)path + this.pkgSuffix : (String)path + "." + this.pkgSuffix;
        }
        return path;
    }

    @Override
    protected String getLanguageNameAttribute() {
        return ATTR_JAVANAME;
    }
}

