/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator;

import com.metaobjects.generator.Generator;
import com.metaobjects.generator.GeneratorException;
import com.metaobjects.generator.MetaDataFilters;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratorBase
implements Generator {
    private static final Logger log = LoggerFactory.getLogger(GeneratorBase.class);
    public static String ARG_OUTPUTDIR = "outputDir";
    public static String ARG_OUTPUTFILENAME = "outputFilename";
    private Map<String, String> args = new HashMap<String, String>();
    private MetaDataFilters filters = new MetaDataFilters();
    private List<String> scripts = new ArrayList<String>();

    @Override
    public GeneratorBase setArgs(Map<String, String> argMap) {
        if (argMap != null) {
            this.args.putAll(argMap);
        }
        return this;
    }

    protected Map<String, String> getArgs() {
        return this.args;
    }

    protected String getArg(String name) {
        if (name == null) {
            return null;
        }
        return this.args.get(name);
    }

    protected String getArg(String name, String defValue) {
        if (!this.hasArg(name)) {
            return defValue;
        }
        return this.getArg(name);
    }

    protected String getArg(String name, boolean required) {
        if (!this.hasArg(name)) {
            throw new GeneratorException("No argument '" + name + "' was specified in the args map");
        }
        return this.getArg(name);
    }

    protected boolean hasArg(String name) {
        return name != null && this.args.containsKey(name);
    }

    @Override
    public GeneratorBase setFilters(List<String> filters) {
        this.filters.addFilters(filters);
        return this;
    }

    protected MetaDataFilters getMetaDataFilters() {
        return this.filters;
    }

    protected List<String> getFilters() {
        return this.filters.getFilters();
    }

    @Override
    public GeneratorBase setScripts(List<String> scripts) {
        this.scripts = scripts;
        return this;
    }

    protected List<String> getScripts() {
        return this.scripts;
    }

    protected String getOutputFilename() {
        return this.getArg(ARG_OUTPUTFILENAME, true);
    }

    protected File getOutputDir() {
        return this.getAndCreateDir(ARG_OUTPUTDIR, this.getArg(ARG_OUTPUTDIR, true));
    }

    protected File getAndCreateDir(String name, String dirPath) {
        File f = new File(dirPath);
        if (!f.exists() && !f.mkdirs()) {
            throw new GeneratorException("Directory [" + dirPath + "] could not be created for argument [" + name + "]");
        }
        return f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("args=").append(this.getArgs());
        sb.append(", filters=").append(this.getFilters());
        sb.append(", scripts=").append(this.getScripts());
        sb.append('}');
        return sb.toString();
    }
}

