/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.generator.direct.util.FileIndentor;
import com.metaobjects.loader.MetaDataLoader;
import java.io.PrintWriter;

public abstract class FileDirectWriter<T extends FileDirectWriter>
extends GeneratorIOWriter<T> {
    private FileIndentor indentor;
    protected final PrintWriter pw;

    public FileDirectWriter(MetaDataLoader loader, PrintWriter pw) {
        super(loader);
        this.pw = pw;
    }

    public T withIndentor(String indentor) {
        this.indentor = new FileIndentor(indentor);
        return (T)((Object)this);
    }

    protected FileIndentor getIndentor() {
        if (this.indentor == null) {
            this.indentor = new FileIndentor("  ");
        }
        return this.indentor;
    }

    protected void inc() {
        this.indentor = this.getIndentor().inc();
    }

    protected void dec() {
        this.indentor = this.getIndentor().dec();
    }

    @Override
    public void close() throws GeneratorIOException {
        this.pw.close();
        if (this.indentor != null && this.indentor.isIndented()) {
            throw new GeneratorIOException(this, "The indenting increment is not back to root level, invalid logic");
        }
    }

    protected void print(String s) {
        this.print(false, s);
    }

    protected void println(String s) {
        this.println(false, s);
    }

    protected void print(boolean indent, String s) {
        this.pw.print((indent ? this.getIndentor().pre() : "") + s);
    }

    protected void println(boolean indent, String s) {
        this.pw.println((indent ? this.getIndentor().pre() : "") + s);
    }

    protected void println() {
        this.pw.println();
    }

    @Override
    protected String getToStringOptions() {
        return "," + String.valueOf(this.getIndentor());
    }
}

