/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct;

import com.metaobjects.generator.GeneratorException;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.generator.MetaDataFilters;
import com.metaobjects.generator.direct.DirectGeneratorBase;
import com.metaobjects.generator.direct.FileDirectWriter;
import com.metaobjects.loader.MetaDataLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class SingleFileDirectGeneratorBase<T extends FileDirectWriter>
extends DirectGeneratorBase {
    @Override
    public void execute(MetaDataLoader loader) {
        String filename = null;
        PrintWriter pw = null;
        FileDirectWriter writer = null;
        this.parseArgs();
        try {
            filename = this.getOutputFilename();
            File outf = new File(this.getOutputDir(), filename);
            outf.createNewFile();
            pw = new PrintWriter(outf);
            writer = this.getWriter(loader, pw);
            ((GeneratorIOWriter)((Object)writer.withFilters(MetaDataFilters.create(this.getFilters())))).withFilename(outf.toString());
            this.writeFile((T)((Object)writer));
        }
        catch (IOException e) {
            throw new GeneratorException("Unable to write to file [" + filename + "]: " + String.valueOf(e), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new GeneratorException("Unable to close file [" + filename + "]: " + String.valueOf(e), e);
                }
            } else if (pw != null) {
                pw.close();
            }
        }
    }

    protected abstract T getWriter(MetaDataLoader var1, PrintWriter var2) throws GeneratorIOException;

    protected abstract void writeFile(T var1) throws GeneratorIOException;
}

