/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.file.json;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.metadata.file.json.MetaDataFileSchemaWriter;
import com.metaobjects.generator.direct.metadata.json.JsonDirectWriter;
import com.metaobjects.generator.direct.metadata.json.SingleJsonDirectGeneratorBase;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.MetaDataRegistry;
import java.io.OutputStream;

public class MetaDataFileJsonSchemaGenerator
extends SingleJsonDirectGeneratorBase {
    public static final String ARG_SCHEMA_VERSION = "schemaVersion";
    public static final String ARG_SCHEMA_ID = "schemaId";
    public static final String ARG_TITLE = "title";
    public static final String ARG_DESCRIPTION = "description";
    private String schemaVersion = "https://json-schema.org/draft/2020-12/schema";
    private String schemaId = null;
    private String title = "MetaData File JSON Schema";
    private String description = "JSON Schema for validating MetaData file structure";
    public static final String JSON_SCHEMA_VERSION = "jsonSchemaVersion";
    public static final String JSON_SCHEMA_ID = "jsonSchemaId";
    public static final String JSON_TITLE = "jsonTitle";
    public static final String JSON_DESCRIPTION = "jsonDescription";
    public static final String JSON_FORMAT = "jsonFormat";
    public static final String JSON_PATTERN = "jsonPattern";
    public static final String JSON_ENUM = "jsonEnum";
    public static final String JSON_MINIMUM = "jsonMinimum";
    public static final String JSON_MAXIMUM = "jsonMaximum";

    @Override
    protected void parseArgs() {
        if (this.hasArg(ARG_SCHEMA_VERSION)) {
            this.schemaVersion = this.getArg(ARG_SCHEMA_VERSION);
        }
        if (this.hasArg(ARG_SCHEMA_ID)) {
            this.schemaId = this.getArg(ARG_SCHEMA_ID);
        }
        if (this.hasArg(ARG_TITLE)) {
            this.title = this.getArg(ARG_TITLE);
        }
        if (this.hasArg(ARG_DESCRIPTION)) {
            this.description = this.getArg(ARG_DESCRIPTION);
        }
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
        }
    }

    @Override
    protected JsonDirectWriter getWriter(MetaDataLoader loader, OutputStream os) throws GeneratorIOException {
        return new MetaDataFileSchemaWriter(loader, os).withSchemaVersion(this.schemaVersion).withSchemaId(this.schemaId).withTitle(this.title).withDescription(this.description);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("args=").append(this.getArgs());
        sb.append(", filters=").append(this.getFilters());
        sb.append(", schemaVersion=").append(this.schemaVersion);
        sb.append(", schemaId=").append(this.schemaId);
        sb.append(", title=").append(this.title);
        sb.append(", description=").append(this.description);
        sb.append('}');
        return sb.toString();
    }

    public static void registerJsonSchemaAttributes(MetaDataRegistry registry) {
        registry.findType("object", "base").optionalAttribute(JSON_SCHEMA_VERSION, "string").optionalAttribute(JSON_SCHEMA_ID, "string").optionalAttribute(JSON_TITLE, "string").optionalAttribute(JSON_DESCRIPTION, "string");
        registry.findType("object", "pojo").optionalAttribute(JSON_TITLE, "string").optionalAttribute(JSON_DESCRIPTION, "string");
        registry.findType("field", "base").optionalAttribute(JSON_TITLE, "string").optionalAttribute(JSON_DESCRIPTION, "string").optionalAttribute(JSON_FORMAT, "string").optionalAttribute(JSON_PATTERN, "string").optionalAttribute(JSON_ENUM, "string");
        registry.findType("field", "string").optionalAttribute(JSON_PATTERN, "string").optionalAttribute(JSON_FORMAT, "string");
        registry.findType("field", "int").optionalAttribute(JSON_MINIMUM, "int").optionalAttribute(JSON_MAXIMUM, "int");
        registry.findType("field", "long").optionalAttribute(JSON_MINIMUM, "long").optionalAttribute(JSON_MAXIMUM, "long");
    }
}

