/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.loader.MetaDataLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public abstract class JsonDirectWriter<T extends JsonDirectWriter>
extends GeneratorIOWriter<T> {
    private OutputStream out;
    private JsonObject jsonObject;
    private Gson gson;

    public JsonDirectWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        super(loader);
        this.out = out;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public abstract void writeJson() throws GeneratorIOException;

    protected void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    protected JsonObject getJsonObject() throws GeneratorIOException {
        if (this.jsonObject == null) {
            this.jsonObject = new JsonObject();
        }
        return this.jsonObject;
    }

    protected void writeJsonToStream(JsonObject json, OutputStream out) throws GeneratorIOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            this.gson.toJson((JsonElement)json, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new GeneratorIOException(this, "Error writing JSON to OutputStream: " + String.valueOf(e), e);
        }
    }

    @Override
    public void close() throws GeneratorIOException {
        this.writeJsonToStream(this.getJsonObject(), this.out);
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new GeneratorIOException(this, "Error closing outputstream: " + String.valueOf(e), e);
        }
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected void setGson(Gson gson) {
        this.gson = gson;
    }
}

