/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.xml;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.loader.MetaDataLoader;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public abstract class XMLDirectWriter<T extends XMLDirectWriter>
extends GeneratorIOWriter<T> {
    private OutputStream out;
    private Document doc;

    public XMLDirectWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        super(loader);
        this.out = out;
    }

    public abstract void writeXML() throws GeneratorIOException;

    protected Document createDocument() throws GeneratorIOException {
        try {
            return XMLDirectWriter.createDocumentBuilder().newDocument();
        }
        catch (IOException e) {
            throw new GeneratorIOException(this, "Error creating XML Builder: " + String.valueOf(e), e);
        }
    }

    protected void writeDocument(Document doc, OutputStream out) throws GeneratorIOException {
        try {
            XMLDirectWriter.writeDocumentToStream(doc, out, true);
        }
        catch (IOException e) {
            throw new GeneratorIOException(this, "Error writing XML Document to Outputstream: " + String.valueOf(e), e);
        }
    }

    protected Document doc() throws GeneratorIOException {
        if (this.doc == null) {
            this.doc = this.createDocument();
        }
        return this.doc;
    }

    @Override
    public void close() throws GeneratorIOException {
        this.writeDocument(this.doc, this.out);
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new GeneratorIOException(this, "Error closing outputstream: " + String.valueOf(e), e);
        }
    }

    private static DocumentBuilder createDocumentBuilder() throws IOException {
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            return documentFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to get a new XML Document Builder: " + e.toString(), e);
        }
    }

    private static void writeDocumentToStream(Document document, OutputStream out, boolean indent) throws IOException {
        try {
            DOMSource domSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            throw new IOException("Unable to write XML document [" + document.getDocumentURI() + "]: " + e.toString(), e);
        }
    }
}

