/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.object;

import com.metaobjects.field.MetaField;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.direct.FileDirectWriter;
import com.metaobjects.generator.direct.GenerationContext;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.object.MetaObject;
import com.metaobjects.util.MetaDataUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseObjectCodeWriter
extends FileDirectWriter<BaseObjectCodeWriter> {
    private static final Logger log = LoggerFactory.getLogger(BaseObjectCodeWriter.class);
    protected boolean debug = false;
    protected GenerationContext context;
    protected Collection<MetaObject> filteredObjects;
    protected String type = "interface";
    protected String pkgPrefix = "";
    protected String pkgSuffix = "";
    protected String namePrefix = "";
    protected String nameSuffix = "";
    protected boolean addArrays = false;
    protected boolean addKeys = false;
    protected MetaObject metaObject = null;
    protected String pkg = null;
    protected String name = null;
    protected String superPkg = null;
    protected String superName = null;
    protected String fullSuperName = null;
    protected MetaObject superObject = null;
    protected Map<MetaField, MetaObject> objectReferenceMap = new HashMap<MetaField, MetaObject>();
    protected List<String> importList = new ArrayList<String>();
    protected Map<MetaObject, String> pkgPrefixMap = new HashMap<MetaObject, String>();

    protected abstract String getLanguageType(MetaField var1);

    protected abstract String getGetterMethodName(MetaField var1);

    protected abstract String getSetterMethodName(MetaField var1);

    protected abstract String getParameterName(MetaField var1);

    protected abstract String getClassName(MetaObject var1);

    protected abstract void writeGetter(String var1, String var2, MetaField var3);

    protected abstract void writeSetter(String var1, String var2, String var3, MetaField var4);

    protected abstract void writeObjectHeader(List<String> var1, String var2, String var3, List<String> var4, String var5);

    protected abstract void writeObjectFooter();

    protected abstract void writeComment(String var1);

    protected abstract void writeNewLine();

    protected abstract String getLanguagePackage(MetaObject var1);

    protected abstract String getLanguageNameAttribute();

    public BaseObjectCodeWriter(MetaDataLoader loader, PrintWriter pw) {
        super(loader, pw);
        this.context = new GenerationContext(loader);
    }

    public BaseObjectCodeWriter(MetaDataLoader loader, PrintWriter pw, GenerationContext context) {
        super(loader, pw);
        this.context = context;
    }

    public BaseObjectCodeWriter forType(String type) {
        this.type = type;
        this.context.setProperty("generator.type", type);
        return this;
    }

    public BaseObjectCodeWriter withPkgPrefix(String pkgPrefix) {
        this.pkgPrefix = pkgPrefix;
        this.context.setProperty("package.prefix", pkgPrefix);
        return this;
    }

    public BaseObjectCodeWriter withPkgSuffix(String pkgSuffix) {
        this.pkgSuffix = pkgSuffix;
        this.context.setProperty("package.suffix", pkgSuffix);
        return this;
    }

    public BaseObjectCodeWriter withNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        this.context.setProperty("name.prefix", namePrefix);
        return this;
    }

    public BaseObjectCodeWriter withNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
        this.context.setProperty("name.suffix", nameSuffix);
        return this;
    }

    public BaseObjectCodeWriter addArrayMethods(boolean addArrays) {
        this.addArrays = addArrays;
        this.context.setProperty("generate.arrayMethods", addArrays);
        return this;
    }

    public BaseObjectCodeWriter addKeyMethods(boolean addKeys) {
        this.addKeys = addKeys;
        this.context.setProperty("generate.keyMethods", addKeys);
        return this;
    }

    public BaseObjectCodeWriter withContext(GenerationContext context) {
        this.context = context;
        return this;
    }

    public GenerationContext getContext() {
        return this.context;
    }

    public String writeObject(MetaObject mo) throws GeneratorIOException {
        this.initVariables(mo);
        this.context.setCurrentObject(mo).setCurrentPackage(this.pkg).setCurrentClassName(this.name);
        try {
            this.initObjectReferenceMap(mo);
            this.initPackagePrefixMap(this.objectReferenceMap.values());
            this.initImportList(this.objectReferenceMap.values());
            this.importList.addAll(this.context.getImports());
            List<String> docs = Arrays.asList("ObjectCodeWriter:         " + ((Object)((Object)this)).getClass().getName(), "MetaObject:               " + mo.getName(), "SuperObject:              " + (this.superObject != null ? this.superObject.getName() : ""), "MetaDataLoader:           " + this.getLoader().toString(), "Generated On:             " + new Date().toString(), "Context:                  " + (this.context != null ? "initialized" : "null"));
            this.writeObjectHeader(docs, this.pkg, this.name, this.importList, this.fullSuperName);
            this.writeObjectMethods(mo);
            this.writeObjectFooter();
            return this.pkg != null && !this.pkg.isEmpty() ? this.pkg + "." + this.name : this.name;
        }
        catch (Exception e) {
            throw new GeneratorIOException(this, "Error writing Object Code: " + String.valueOf(e), e);
        }
    }

    protected void writeObjectMethods(MetaObject mo) {
        this.inc();
        for (MetaField mf : mo.getMetaFields(false)) {
            this.context.setCurrentField(mf);
            boolean generateGetters = this.context.getBooleanProperty("generate.getters", true);
            boolean generateSetters = this.context.getBooleanProperty("generate.setters", true);
            if (!generateGetters && !generateSetters) continue;
            String getterName = this.getGetterMethodName(mf);
            String setterName = this.getSetterMethodName(mf);
            String paramName = this.getParameterName(mf);
            String typeName = this.getLanguageType(mf);
            this.writeNewLine();
            this.writeComment("Methods for MetaField: " + mf.getName());
            this.writeNewLine();
            if (generateGetters) {
                this.writeGetter(getterName, typeName, mf);
            }
            if (!generateSetters) continue;
            this.writeSetter(setterName, paramName, typeName, mf);
        }
        this.dec();
    }

    protected void initVariables(MetaObject mo) {
        this.metaObject = mo;
        this.pkg = this.getLanguagePackage(mo);
        this.name = this.getClassName(mo);
        if (this.hasSuperObject(mo)) {
            this.superObject = mo.getSuperObject();
            this.superPkg = this.getLanguagePackage(this.superObject);
            this.superName = this.getClassName(this.superObject);
            this.fullSuperName = !this.pkg.equals(this.superPkg) ? this.superPkg + "." + this.superName : this.superName;
        } else {
            this.superObject = null;
            this.superPkg = null;
            this.superName = null;
            this.fullSuperName = null;
        }
    }

    protected void initObjectReferenceMap(MetaObject mo) {
        for (MetaField mf : mo.getMetaFields(false)) {
            if (!MetaDataUtil.hasObjectRef((MetaField)mf)) continue;
            this.objectReferenceMap.put(mf, MetaDataUtil.getObjectRef((MetaField)mf));
        }
    }

    protected void initPackagePrefixMap(Collection<MetaObject> refObjects) {
        if (this.superObject != null) {
            this.addPackagePrefixToMap(this.superObject);
        }
        for (MetaObject refmo : refObjects) {
            this.addPackagePrefixToMap(refmo);
        }
    }

    protected void initImportList(Collection<MetaObject> refObjects) {
        if (this.superObject != null) {
            this.addImportToList(this.superObject);
        }
        for (MetaObject refmo : refObjects) {
            this.addImportToList(refmo);
        }
    }

    private boolean hasSuperObject(MetaObject mo) {
        return mo.getSuperData() != null && mo.getSuperData() instanceof MetaObject;
    }

    protected void addPackagePrefixToMap(MetaObject refmo) {
        String p = this.getLanguagePackage(refmo);
        String n = this.getClassName(refmo);
        if (!this.pkg.equals(p) && this.name.equals(n)) {
            this.pkgPrefixMap.put(refmo, p + ".");
        } else {
            this.pkgPrefixMap.put(refmo, "");
        }
    }

    private void addImportToList(MetaObject mo) {
        String p = this.getLanguagePackage(mo);
        String n = this.getClassName(mo);
        if (!(this.pkg.equals(p) || this.name.equals(n) || this.importList.contains(p))) {
            this.importList.add(p + "." + n);
        }
    }

    protected boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

