/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.util;

import com.metaobjects.MetaData;
import com.metaobjects.generator.MetaDataFilters;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.object.MetaObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GeneratorUtil {
    public static Collection<MetaData> getFilteredMetaData(MetaDataLoader loader, MetaDataFilters filters) {
        return GeneratorUtil.filterMetaData(loader.getChildren(), MetaData.class, filters);
    }

    public static <T extends MetaData> Collection<T> getFilteredMetaData(MetaDataLoader loader, Class<T> clazz, MetaDataFilters filters) {
        return GeneratorUtil.filterMetaData(loader.getMetaData(clazz), clazz, filters);
    }

    private static <T extends MetaData> Collection<T> filterMetaData(Collection<T> in, Class<T> clazz, MetaDataFilters filtersIn) {
        List<String> filters;
        ArrayList<Object> out = new ArrayList<Object>();
        List<String> list = filters = filtersIn == null ? null : filtersIn.getFilters();
        if (filters == null || filters.isEmpty()) {
            out.addAll(in);
        } else {
            List incFilters = filters.stream().filter(f -> !f.startsWith("!")).collect(Collectors.toList());
            List excFilters = filters.stream().filter(f -> f.startsWith("!")).collect(Collectors.toList());
            for (MetaData md : in) {
                boolean shouldAdd = incFilters.isEmpty();
                for (String f2 : incFilters) {
                    if (!GeneratorUtil.filterMatch(md, f2)) continue;
                    shouldAdd = true;
                    break;
                }
                for (String f2 : excFilters) {
                    if (!GeneratorUtil.filterMatch(md, f2.substring(1))) continue;
                    shouldAdd = false;
                    break;
                }
                if (!shouldAdd) continue;
                out.add(md);
            }
        }
        return out;
    }

    public static boolean filterMatch(MetaData md, String filter) {
        boolean match;
        String f = filter;
        int i = filter.indexOf(".[");
        if (i > 0) {
            f = filter.substring(0, i);
        }
        if ((match = GeneratorUtil.filterByName(md.getName(), f)) && i > 0) {
            match = GeneratorUtil.filterByMetaData(md, filter.substring(i + 1).trim());
        }
        return match;
    }

    public static boolean filterByMetaData(MetaData md, String metaDataFilter) {
        block6: {
            if (metaDataFilter == null || metaDataFilter.trim().isEmpty()) {
                return false;
            }
            try {
                String[] attrs;
                String[] v1 = metaDataFilter.split("=");
                if (v1.length <= 0 || (attrs = v1[0].split(":")).length != 2 || !attrs[0].equals("[attr")) break block6;
                String attrName = attrs[1];
                if (attrName.length() < 2 || !attrName.endsWith("]")) {
                    return false;
                }
                String an = attrName.substring(0, attrName.length() - 1);
                if (!md.hasMetaAttr(an)) break block6;
                if (v1.length > 1) {
                    String[] vals = v1[1].split("\"");
                    if (vals.length > 0) {
                        return vals[0].equals(md.getMetaAttr(an).getValueAsString());
                    }
                    break block6;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean filterByName(String metaDataName, String nameFilter) {
        return Pattern.compile(GeneratorUtil.createRegexFromGlob(nameFilter)).matcher(metaDataName).matches();
    }

    private static String createRegexFromGlob(String glob) {
        Object out = "^";
        block8: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out = (String)out + ".*";
                    continue block8;
                }
                case '@': {
                    out = (String)out + "[^:]+";
                    continue block8;
                }
                case '?': {
                    out = (String)out + ".";
                    continue block8;
                }
                case '.': {
                    out = (String)out + "\\.";
                    continue block8;
                }
                case ':': {
                    out = (String)out + "\\:";
                    continue block8;
                }
                case '\\': {
                    out = (String)out + "\\\\";
                    continue block8;
                }
                default: {
                    out = (String)out + c;
                }
            }
        }
        out = (String)out + "$";
        return out;
    }

    public static String toRelativePackage(String p1, String p2) {
        int i;
        int n;
        String[] p2s;
        if (p1.isEmpty() && p2.isEmpty()) {
            return "";
        }
        if (p2.isEmpty()) {
            return "";
        }
        if (p1.isEmpty()) {
            return p2 + "::";
        }
        String[] p1s = p1.split("::");
        if (!p1s[0].equals((p2s = p2.split("::"))[0])) {
            return p2 + "::";
        }
        int max = p1s.length;
        if (p2s.length < p1s.length) {
            max = p2s.length;
        }
        for (n = 0; max > n && p1s[n].equals(p2s[n]); ++n) {
        }
        StringBuilder out = new StringBuilder();
        if (p2s.length < p1s.length) {
            out.append("...::");
        } else if (n == max) {
            out.append("::");
        } else {
            for (i = n; i < max; ++i) {
                out.append("..::");
            }
        }
        for (i = n; i < p2s.length; ++i) {
            out.append(p2s[i] + "::");
        }
        return out.toString();
    }

    public static String toCamelCase(String text, boolean capitalizeFirstChar) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder converted = new StringBuilder();
        boolean first = true;
        boolean convertNext = false;
        for (char ch : text.toCharArray()) {
            if (ch == '-') {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
                converted.append(ch);
            } else if (first && capitalizeFirstChar) {
                ch = Character.toTitleCase(ch);
                converted.append(ch);
            } else {
                converted.append(ch);
            }
            if (!first) continue;
            first = false;
        }
        return converted.toString();
    }

    public static List<String> getUniquePackages(Collection<? extends MetaData> filtered) throws IOException {
        ArrayList<String> pkgs = new ArrayList<String>();
        filtered.forEach(md -> {
            if (md instanceof MetaObject && !pkgs.contains(md.getPackage())) {
                pkgs.add(md.getPackage());
            }
        });
        return pkgs;
    }

    public static boolean isAbstract(MetaData md) {
        return md.hasMetaAttr("_isAbstract") && Boolean.TRUE.equals(md.getMetaAttr("_isAbstract").getValue());
    }
}

