/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IProvider;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.IdCollection;
import com.microsoft.java.debug.core.adapter.LRUCache;
import com.microsoft.java.debug.core.adapter.RecyclableObjectPool;
import com.microsoft.java.debug.core.adapter.StackFrameManager;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.VariableFormatterFactory;
import com.microsoft.java.debug.core.protocol.IProtocolServer;
import com.microsoft.java.debug.core.protocol.Requests;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class DebugAdapterContext
implements IDebugAdapterContext {
    private static final int MAX_CACHE_ITEMS = 10000;
    private Map<String, String> sourceMappingCache = Collections.synchronizedMap(new LRUCache(10000));
    private IProviderContext providerContext;
    private IProtocolServer server;
    private IDebugSession debugSession;
    private boolean debuggerLinesStartAt1 = true;
    private boolean debuggerPathsAreUri = true;
    private boolean clientLinesStartAt1 = true;
    private boolean clientPathsAreUri = false;
    private boolean supportsRunInTerminalRequest;
    private boolean isAttached = false;
    private String[] sourcePaths;
    private Charset debuggeeEncoding;
    private transient boolean vmTerminated;
    private boolean isVmStopOnEntry = false;
    private String mainClass;
    private Requests.StepFilters stepFilters;
    private IdCollection<String> sourceReferences = new IdCollection();
    private RecyclableObjectPool<Long, Object> recyclableIdPool = new RecyclableObjectPool();
    private IVariableFormatter variableFormatter = VariableFormatterFactory.createVariableFormatter();
    private IStackFrameManager stackFrameManager = new StackFrameManager();

    public DebugAdapterContext(IProtocolServer server, IProviderContext providerContext) {
        this.providerContext = providerContext;
        this.server = server;
    }

    @Override
    public IProtocolServer getProtocolServer() {
        return this.server;
    }

    @Override
    public <T extends IProvider> T getProvider(Class<T> clazz) {
        return this.providerContext.getProvider(clazz);
    }

    @Override
    public void setDebugSession(IDebugSession session) {
        this.debugSession = session;
    }

    @Override
    public IDebugSession getDebugSession() {
        return this.debugSession;
    }

    @Override
    public boolean isDebuggerLinesStartAt1() {
        return this.debuggerLinesStartAt1;
    }

    @Override
    public void setDebuggerLinesStartAt1(boolean debuggerLinesStartAt1) {
        this.debuggerLinesStartAt1 = debuggerLinesStartAt1;
    }

    @Override
    public boolean isDebuggerPathsAreUri() {
        return this.debuggerPathsAreUri;
    }

    @Override
    public void setDebuggerPathsAreUri(boolean debuggerPathsAreUri) {
        this.debuggerPathsAreUri = debuggerPathsAreUri;
    }

    @Override
    public boolean isClientLinesStartAt1() {
        return this.clientLinesStartAt1;
    }

    @Override
    public void setClientLinesStartAt1(boolean clientLinesStartAt1) {
        this.clientLinesStartAt1 = clientLinesStartAt1;
    }

    @Override
    public boolean isClientPathsAreUri() {
        return this.clientPathsAreUri;
    }

    @Override
    public void setClientPathsAreUri(boolean clientPathsAreUri) {
        this.clientPathsAreUri = clientPathsAreUri;
    }

    @Override
    public void setSupportsRunInTerminalRequest(boolean supportsRunInTerminalRequest) {
        this.supportsRunInTerminalRequest = supportsRunInTerminalRequest;
    }

    @Override
    public boolean supportsRunInTerminalRequest() {
        return this.supportsRunInTerminalRequest;
    }

    @Override
    public boolean isAttached() {
        return this.isAttached;
    }

    @Override
    public void setAttached(boolean attached) {
        this.isAttached = attached;
    }

    @Override
    public String[] getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public void setSourcePaths(String[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    @Override
    public String getSourceUri(int sourceReference) {
        return this.sourceReferences.get(sourceReference);
    }

    @Override
    public int createSourceReference(String uri) {
        return this.sourceReferences.create(uri);
    }

    @Override
    public RecyclableObjectPool<Long, Object> getRecyclableIdPool() {
        return this.recyclableIdPool;
    }

    @Override
    public void setRecyclableIdPool(RecyclableObjectPool<Long, Object> idPool) {
        this.recyclableIdPool = idPool;
    }

    @Override
    public IVariableFormatter getVariableFormatter() {
        return this.variableFormatter;
    }

    @Override
    public void setVariableFormatter(IVariableFormatter variableFormatter) {
        this.variableFormatter = variableFormatter;
    }

    @Override
    public Map<String, String> getSourceLookupCache() {
        return this.sourceMappingCache;
    }

    @Override
    public void setDebuggeeEncoding(Charset encoding) {
        this.debuggeeEncoding = encoding;
    }

    @Override
    public Charset getDebuggeeEncoding() {
        return this.debuggeeEncoding;
    }

    @Override
    public void setVmTerminated() {
        this.vmTerminated = true;
    }

    @Override
    public boolean isVmTerminated() {
        return this.vmTerminated;
    }

    @Override
    public void setVmStopOnEntry(boolean stopOnEntry) {
        this.isVmStopOnEntry = stopOnEntry;
    }

    @Override
    public boolean isVmStopOnEntry() {
        return this.isVmStopOnEntry;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setStepFilters(Requests.StepFilters stepFilters) {
        this.stepFilters = stepFilters;
    }

    @Override
    public Requests.StepFilters getStepFilters() {
        return this.stepFilters;
    }

    @Override
    public IStackFrameManager getStackFrameManager() {
        return this.stackFrameManager;
    }
}

