/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugEvent;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ThreadsRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.StepRequest;
import io.reactivex.disposables.Disposable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;

public class StepRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STEPIN, Requests.Command.STEPOUT, Requests.Command.NEXT);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Debug Session doesn't exist.");
        }
        long threadId = ((Requests.StepArguments)arguments).threadId;
        ThreadReference thread = DebugUtility.getThread(context.getDebugSession(), threadId);
        if (thread != null) {
            try {
                ThreadState threadState = new ThreadState();
                threadState.threadId = threadId;
                threadState.pendingStepType = command;
                threadState.stackDepth = thread.frameCount();
                threadState.stepLocation = this.getTopFrame(thread).location();
                threadState.eventSubscription = context.getDebugSession().getEventHub().events().filter(debugEvent -> debugEvent.event instanceof StepEvent && debugEvent.event.request().equals(threadState.pendingStepRequest) || debugEvent.event instanceof BreakpointEvent).subscribe(debugEvent -> this.handleDebugEvent((DebugEvent)debugEvent, context.getDebugSession(), context, threadState));
                threadState.pendingStepRequest = command == Requests.Command.STEPIN ? DebugUtility.createStepIntoRequest(thread, context.getStepFilters().classNameFilters) : (command == Requests.Command.STEPOUT ? DebugUtility.createStepOutRequest(thread, context.getStepFilters().classNameFilters) : DebugUtility.createStepOverRequest(thread, context.getStepFilters().classNameFilters));
                threadState.pendingStepRequest.enable();
                DebugUtility.resumeThread(thread);
                ThreadsRequestHandler.checkThreadRunningAndRecycleIds(thread, context);
            }
            catch (IncompatibleThreadStateException ex) {
                String failureMessage = String.format("Failed to step because the thread '%s' is not suspended in the target VM.", thread.name());
                throw AdapterUtils.createCompletionException(failureMessage, ErrorCode.STEP_FAILURE, ex);
            }
            catch (IndexOutOfBoundsException ex) {
                String failureMessage = String.format("Failed to step because the thread '%s' doesn't contain any stack frame", thread.name());
                throw AdapterUtils.createCompletionException(failureMessage, ErrorCode.STEP_FAILURE, ex);
            }
        }
        return CompletableFuture.completedFuture(response);
    }

    private void handleDebugEvent(DebugEvent debugEvent, IDebugSession debugSession, IDebugAdapterContext context, ThreadState threadState) {
        Event event = debugEvent.event;
        if (event instanceof BreakpointEvent) {
            long threadId = ((BreakpointEvent)event).thread().uniqueID();
            if (threadId == threadState.threadId && threadState.pendingStepRequest != null) {
                DebugUtility.deleteEventRequestSafely(debugSession.getVM().eventRequestManager(), threadState.pendingStepRequest);
                threadState.pendingStepRequest = null;
                if (threadState.eventSubscription != null) {
                    threadState.eventSubscription.dispose();
                }
            }
        } else if (event instanceof StepEvent) {
            ThreadReference thread = ((StepEvent)event).thread();
            DebugUtility.deleteEventRequestSafely(thread.virtualMachine().eventRequestManager(), threadState.pendingStepRequest);
            threadState.pendingStepRequest = null;
            if (this.isStepFiltersConfigured(context.getStepFilters())) {
                try {
                    if (threadState.pendingStepType == Requests.Command.STEPIN) {
                        int currentStackDepth = thread.frameCount();
                        Location currentStepLocation = this.getTopFrame(thread).location();
                        if (threadState.stackDepth + 1 < thread.frameCount()) {
                            threadState.pendingStepRequest = DebugUtility.createStepOutRequest(thread, context.getStepFilters().classNameFilters);
                            threadState.pendingStepRequest.enable();
                            debugEvent.shouldResume = true;
                            return;
                        }
                        if (this.shouldFilterLocation(threadState.stepLocation, currentStepLocation, context) || this.shouldDoExtraStepInto(threadState.stackDepth, threadState.stepLocation, currentStackDepth, currentStepLocation)) {
                            threadState.pendingStepRequest = DebugUtility.createStepIntoRequest(thread, context.getStepFilters().classNameFilters);
                            threadState.pendingStepRequest.enable();
                            debugEvent.shouldResume = true;
                            return;
                        }
                    }
                }
                catch (IncompatibleThreadStateException | IndexOutOfBoundsException exception) {
                    // empty catch block
                }
            }
            if (threadState.eventSubscription != null) {
                threadState.eventSubscription.dispose();
            }
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("step", thread.uniqueID()));
            debugEvent.shouldResume = false;
        }
    }

    private boolean isStepFiltersConfigured(Requests.StepFilters filters) {
        if (filters == null) {
            return false;
        }
        return ArrayUtils.isNotEmpty((Object[])filters.classNameFilters) || filters.skipConstructors || filters.skipStaticInitializers || filters.skipSynthetics;
    }

    private boolean shouldFilterLocation(Location originalLocation, Location currentLocation, IDebugAdapterContext context) throws IncompatibleThreadStateException {
        if (originalLocation == null || currentLocation == null) {
            return false;
        }
        return !this.shouldFilterMethod(originalLocation.method(), context) && this.shouldFilterMethod(currentLocation.method(), context);
    }

    private boolean shouldFilterMethod(Method method, IDebugAdapterContext context) {
        return context.getStepFilters().skipStaticInitializers && method.isStaticInitializer() || context.getStepFilters().skipSynthetics && method.isSynthetic() || context.getStepFilters().skipConstructors && method.isConstructor();
    }

    private boolean shouldDoExtraStepInto(int originalStackDepth, Location originalLocation, int currentStackDepth, Location currentLocation) throws IncompatibleThreadStateException {
        Method currentMethod;
        if (originalStackDepth != currentStackDepth) {
            return false;
        }
        if (originalLocation == null) {
            return false;
        }
        Method originalMethod = originalLocation.method();
        if (!originalMethod.equals(currentMethod = currentLocation.method())) {
            return false;
        }
        return originalLocation.lineNumber() == currentLocation.lineNumber();
    }

    private StackFrame getTopFrame(ThreadReference thread) throws IncompatibleThreadStateException {
        return thread.frame(0);
    }

    class ThreadState {
        long threadId = -1L;
        Requests.Command pendingStepType;
        StepRequest pendingStepRequest = null;
        int stackDepth = -1;
        Location stepLocation = null;
        Disposable eventSubscription = null;

        ThreadState() {
        }
    }
}

