/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.DebugSession;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.IDebugSession;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class DebugUtility {
    public static final String HOME = "home";
    public static final String OPTIONS = "options";
    public static final String MAIN = "main";
    public static final String SUSPEND = "suspend";
    public static final String QUOTE = "quote";
    public static final String EXEC = "vmexec";
    public static final String CWD = "cwd";
    public static final String ENV = "env";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String TIMEOUT = "timeout";

    public static IDebugSession launch(VirtualMachineManager vmManager, String mainClass, String programArguments, String vmArguments, List<String> modulePaths, List<String> classPaths, String cwd, String[] envVars) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        return DebugUtility.launch(vmManager, mainClass, programArguments, vmArguments, String.join((CharSequence)File.pathSeparator, modulePaths), String.join((CharSequence)File.pathSeparator, classPaths), cwd, envVars);
    }

    public static IDebugSession launch(VirtualMachineManager vmManager, String mainClass, String programArguments, String vmArguments, String modulePaths, String classPaths, String cwd, String[] envVars) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        List<LaunchingConnector> connectors = vmManager.launchingConnectors();
        LaunchingConnector connector = connectors.get(0);
        String SUN_LAUNCHING_CONNECTOR = "com.sun.tools.jdi.SunCommandLineLauncher";
        for (LaunchingConnector con : connectors) {
            if (!con.getClass().getName().equals("com.sun.tools.jdi.SunCommandLineLauncher")) continue;
            connector = con;
            break;
        }
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get(SUSPEND).setValue("true");
        String options = "";
        if (StringUtils.isNotBlank((CharSequence)vmArguments)) {
            options = vmArguments;
        }
        if (StringUtils.isNotBlank((CharSequence)modulePaths)) {
            options = options + " --module-path \"" + modulePaths + "\"";
        }
        if (StringUtils.isNotBlank((CharSequence)classPaths)) {
            options = options + " -cp \"" + classPaths + "\"";
        }
        arguments.get(OPTIONS).setValue(options);
        String[] mainClasses = mainClass.split("/");
        if (StringUtils.isNotBlank((CharSequence)modulePaths) || mainClasses.length == 2) {
            mainClass = "-m " + mainClass;
        }
        if (StringUtils.isNotBlank((CharSequence)programArguments)) {
            mainClass = mainClass + " " + programArguments;
        }
        arguments.get(MAIN).setValue(mainClass);
        if (arguments.get(CWD) != null) {
            arguments.get(CWD).setValue(cwd);
        }
        if (arguments.get(ENV) != null) {
            arguments.get(ENV).setValue(DebugUtility.encodeArrayArgument(envVars));
        }
        if (StringUtils.isNotEmpty((CharSequence)DebugSettings.getCurrent().javaHome)) {
            arguments.get(HOME).setValue(DebugSettings.getCurrent().javaHome);
        }
        VirtualMachine vm = connector.launch(arguments);
        vm.version();
        return new DebugSession(vm);
    }

    public static IDebugSession attach(VirtualMachineManager vmManager, String hostName, int port, int attachTimeout) throws IOException, IllegalConnectorArgumentsException {
        List<AttachingConnector> connectors = vmManager.attachingConnectors();
        AttachingConnector connector = connectors.get(0);
        String SUN_ATTACH_CONNECTOR = "com.sun.tools.jdi.SocketAttachingConnector";
        for (AttachingConnector con : connectors) {
            if (!con.getClass().getName().equals("com.sun.tools.jdi.SocketAttachingConnector")) continue;
            connector = con;
            break;
        }
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get(HOSTNAME).setValue(hostName);
        arguments.get(PORT).setValue(String.valueOf(port));
        arguments.get(TIMEOUT).setValue(String.valueOf(attachTimeout));
        return new DebugSession(connector.attach(arguments));
    }

    public static StepRequest createStepOverRequest(ThreadReference thread, String[] stepFilters) {
        return DebugUtility.createStepRequest(thread, -2, 2, stepFilters);
    }

    public static StepRequest createStepIntoRequest(ThreadReference thread, String[] stepFilters) {
        return DebugUtility.createStepRequest(thread, -2, 1, stepFilters);
    }

    public static StepRequest createStepOutRequest(ThreadReference thread, String[] stepFilters) {
        return DebugUtility.createStepRequest(thread, -2, 3, stepFilters);
    }

    private static StepRequest createStepRequest(ThreadReference thread, int stepSize, int stepDepth, String[] stepFilters) {
        StepRequest request = thread.virtualMachine().eventRequestManager().createStepRequest(thread, stepSize, stepDepth);
        if (stepFilters != null) {
            for (String stepFilter : stepFilters) {
                request.addClassExclusionFilter(stepFilter);
            }
        }
        request.setSuspendPolicy(1);
        request.addCountFilter(1);
        return request;
    }

    public static CompletableFuture<Long> stopOnEntry(IDebugSession debugSession, String mainClass) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        EventRequestManager manager = debugSession.getVM().eventRequestManager();
        MethodEntryRequest request = manager.createMethodEntryRequest();
        request.addClassFilter(mainClass);
        request.setSuspendPolicy(1);
        debugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof MethodEntryEvent && request.equals(debugEvent.event.request())).subscribe(debugEvent -> {
            Method method = ((MethodEntryEvent)debugEvent.event).method();
            if (method.isPublic() && method.isStatic() && method.name().equals(MAIN) && method.signature().equals("([Ljava/lang/String;)V")) {
                DebugUtility.deleteEventRequestSafely(debugSession.getVM().eventRequestManager(), request);
                debugEvent.shouldResume = false;
                ThreadReference bpThread = ((MethodEntryEvent)debugEvent.event).thread();
                future.complete(bpThread.uniqueID());
            }
        });
        request.enable();
        return future;
    }

    public static ThreadReference getThread(IDebugSession debugSession, long threadId) {
        for (ThreadReference thread : DebugUtility.getAllThreadsSafely(debugSession)) {
            if (thread.uniqueID() != threadId || thread.isCollected()) continue;
            return thread;
        }
        return null;
    }

    public static List<ThreadReference> getAllThreadsSafely(IDebugSession debugSession) {
        if (debugSession != null) {
            try {
                return debugSession.getAllThreads();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        return new ArrayList<ThreadReference>();
    }

    public static void resumeThread(ThreadReference thread) {
        if (thread == null || thread.isCollected()) {
            return;
        }
        try {
            int suspends = thread.suspendCount();
            for (int i = 0; i < suspends; ++i) {
                thread.resume();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public static void deleteEventRequestSafely(EventRequestManager eventManager, EventRequest request) {
        try {
            eventManager.deleteEventRequest(request);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public static void deleteEventRequestSafely(EventRequestManager eventManager, List<EventRequest> requests) {
        try {
            eventManager.deleteEventRequests(requests);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public static String encodeArrayArgument(String[] argument) {
        if (argument == null) {
            return null;
        }
        ArrayList<String> encodedArgs = new ArrayList<String>();
        for (String arg : argument) {
            try {
                encodedArgs.add(URLEncoder.encode(arg, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return String.join((CharSequence)"\n", encodedArgs);
    }

    public static String[] decodeArrayArgument(String argument) {
        String[] splits;
        if (argument == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String split : splits = argument.split("\n")) {
            try {
                result.add(URLDecoder.decode(split, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result.toArray(new String[0]);
    }
}

