/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.Breakpoint;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.VirtualMachine;
import org.apache.commons.lang3.StringUtils;

public class EvaluatableBreakpoint
extends Breakpoint
implements IEvaluatableBreakpoint {
    private Object compiledConditionalExpression = null;
    private Object compiledLogpointExpression = null;

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber) {
        super(vm, eventHub, className, lineNumber, 0, null);
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount) {
        super(vm, eventHub, className, lineNumber, hitCount, null);
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition) {
        super(vm, eventHub, className, lineNumber, hitCount, condition);
    }

    EvaluatableBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition, String logMessage) {
        super(vm, eventHub, className, lineNumber, hitCount, condition, logMessage);
    }

    @Override
    public boolean containsEvaluatableExpression() {
        return this.containsConditionalExpression() || this.containsLogpointExpression();
    }

    @Override
    public boolean containsConditionalExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getCondition());
    }

    @Override
    public boolean containsLogpointExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getLogMessage());
    }

    @Override
    public void setCompiledConditionalExpression(Object compiledExpression) {
        this.compiledConditionalExpression = compiledExpression;
    }

    @Override
    public Object getCompiledConditionalExpression() {
        return this.compiledConditionalExpression;
    }

    @Override
    public void setCompiledLogpointExpression(Object compiledExpression) {
        this.compiledLogpointExpression = compiledExpression;
    }

    @Override
    public Object getCompiledLogpointExpression() {
        return this.compiledLogpointExpression;
    }

    @Override
    public void setCondition(String condition) {
        super.setCondition(condition);
        this.setCompiledConditionalExpression(null);
    }

    @Override
    public void setLogMessage(String logMessage) {
        super.setLogMessage(logMessage);
        this.setCompiledLogpointExpression(null);
    }
}

