/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugEvent;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.JdiExceptionReference;
import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public class ConfigurationDoneRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.CONFIGURATIONDONE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        IDebugSession debugSession = context.getDebugSession();
        if (debugSession != null) {
            debugSession.getEventHub().events().subscribe(debugEvent -> this.handleDebugEvent((DebugEvent)debugEvent, debugSession, context));
            debugSession.start();
            return CompletableFuture.completedFuture(response);
        }
        context.getProtocolServer().sendEvent(new Events.TerminatedEvent());
        return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Failed to launch debug session, the debugger will exit.");
    }

    private void handleDebugEvent(DebugEvent debugEvent, IDebugSession debugSession, IDebugAdapterContext context) {
        Event event = debugEvent.event;
        boolean isImportantEvent = true;
        if (event instanceof VMStartEvent) {
            if (context.isVmStopOnEntry()) {
                DebugUtility.stopOnEntry(debugSession, context.getMainClass()).thenAccept(threadId -> context.getProtocolServer().sendEvent(new Events.StoppedEvent("entry", (long)threadId)));
            }
        } else if (event instanceof VMDeathEvent) {
            context.setVmTerminated();
            context.getProtocolServer().sendEvent(new Events.ExitedEvent(0));
        } else if (event instanceof VMDisconnectEvent) {
            context.setVmTerminated();
            context.getProtocolServer().sendEvent(new Events.TerminatedEvent());
            try {
                debugSession.getEventHub().close();
            }
            catch (Exception exception) {}
        } else if (event instanceof ThreadStartEvent) {
            ThreadReference startThread = ((ThreadStartEvent)event).thread();
            Events.ThreadEvent threadEvent = new Events.ThreadEvent("started", startThread.uniqueID());
            context.getProtocolServer().sendEvent(threadEvent);
        } else if (event instanceof ThreadDeathEvent) {
            ThreadReference deathThread = ((ThreadDeathEvent)event).thread();
            Events.ThreadEvent threadDeathEvent = new Events.ThreadEvent("exited", deathThread.uniqueID());
            context.getProtocolServer().sendEvent(threadDeathEvent);
        } else if (!(event instanceof BreakpointEvent)) {
            if (event instanceof ExceptionEvent) {
                ThreadReference thread = ((ExceptionEvent)event).thread();
                ThreadReference bpThread = ((ExceptionEvent)event).thread();
                IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
                if (engine.isInEvaluation(bpThread)) {
                    return;
                }
                JdiExceptionReference jdiException = new JdiExceptionReference(((ExceptionEvent)event).exception(), ((ExceptionEvent)event).catchLocation() == null);
                context.getExceptionManager().setException(thread.uniqueID(), jdiException);
                context.getProtocolServer().sendEvent(new Events.StoppedEvent("exception", thread.uniqueID()));
                debugEvent.shouldResume = false;
            } else {
                isImportantEvent = false;
            }
        }
        if (isImportantEvent) {
            UsageDataSession.recordEvent(event);
        }
    }
}

