/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDisconnectRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.DISCONNECT);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        this.destroyDebugSession(command, arguments, response, context);
        this.destroyResource(context);
        return CompletableFuture.completedFuture(response);
    }

    private void destroyResource(IDebugAdapterContext context) {
        this.destroyProviders(context);
        if (this.shouldDestroyLaunchFiles(context)) {
            this.destroyLaunchFiles(context);
        }
    }

    private boolean shouldDestroyLaunchFiles(IDebugAdapterContext context) {
        return context.getLaunchMode() == LaunchMode.DEBUG || context.getDebuggeeProcess() != null;
    }

    private void destroyLaunchFiles(IDebugAdapterContext context) {
        int retry = 5;
        while (retry-- > 0) {
            try {
                if (context.getClasspathJar() != null) {
                    Files.deleteIfExists(context.getClasspathJar());
                    context.setClasspathJar(null);
                }
                if (context.getArgsfile() == null) break;
                Files.deleteIfExists(context.getArgsfile());
                context.setArgsfile(null);
                break;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to destory launch files, will retry again.");
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract void destroyDebugSession(Requests.Command var1, Requests.Arguments var2, Messages.Response var3, IDebugAdapterContext var4);

    protected void destroyProviders(IDebugAdapterContext context) {
        IHotCodeReplaceProvider hcrProvider = context.getProvider(IHotCodeReplaceProvider.class);
        if (hcrProvider != null) {
            hcrProvider.close();
        }
    }
}

