/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.formatter.ArrayObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.BooleanFormatter;
import com.microsoft.java.debug.core.adapter.formatter.CharacterFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ClassObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NullObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.SimpleTypeFormatter;
import com.microsoft.java.debug.core.adapter.formatter.StringObjectFormatter;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.VariableFormatter;

public final class VariableFormatterFactory {
    private VariableFormatterFactory() {
    }

    public static IVariableFormatter createVariableFormatter() {
        VariableFormatter formatter = new VariableFormatter();
        formatter.registerTypeFormatter(new SimpleTypeFormatter(), 1);
        formatter.registerValueFormatter(new BooleanFormatter(), 1);
        formatter.registerValueFormatter(new CharacterFormatter(), 1);
        formatter.registerValueFormatter(new NumericFormatter(), 1);
        formatter.registerValueFormatter(new ObjectFormatter(formatter::typeToString), 1);
        formatter.registerValueFormatter(new NullObjectFormatter(), 1);
        formatter.registerValueFormatter(new StringObjectFormatter(), 2);
        formatter.registerValueFormatter(new ArrayObjectFormatter(formatter::typeToString), 2);
        formatter.registerValueFormatter(new ClassObjectFormatter(formatter::typeToString), 2);
        return formatter;
    }
}

