/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import sun.security.action.GetPropertyAction;

public class AdapterUtils {
    private static final String OS_NAME = System.getProperty("os.name", "").toLowerCase();
    private static final Pattern ENCLOSING_CLASS_REGEX = Pattern.compile("^([^\\$]*)");
    public static final boolean isWin = AdapterUtils.isWindows();
    public static final boolean isMac = OS_NAME.contains("mac") || OS_NAME.contains("darwin");
    private static Path tmpdir = null;

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static String sourceLookup(String[] sourcePaths, String sourceName) {
        if (sourcePaths != null) {
            for (String path : sourcePaths) {
                Path fullpath = Paths.get(path, sourceName);
                if (!Files.isRegularFile(fullpath, new LinkOption[0])) continue;
                return fullpath.toString();
            }
        }
        return null;
    }

    public static String parseEnclosingType(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        Matcher matcher = ENCLOSING_CLASS_REGEX.matcher(fullyQualifiedName);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static int convertLineNumber(int line, boolean sourceLinesStartAt1, boolean targetLinesStartAt1) {
        if (sourceLinesStartAt1) {
            return targetLinesStartAt1 ? line : line - 1;
        }
        return targetLinesStartAt1 ? line + 1 : line;
    }

    public static String convertPath(String path, boolean sourceIsUri, boolean targetIsUri) {
        if (path == null) {
            return null;
        }
        if (sourceIsUri == targetIsUri) {
            return path;
        }
        if (sourceIsUri && !targetIsUri) {
            return AdapterUtils.toPath(path);
        }
        return AdapterUtils.toUri(path);
    }

    public static String toPath(String uri) {
        try {
            return Paths.get(new URI(uri)).toString();
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException e) {
            return null;
        }
    }

    public static String toUri(String path) {
        try {
            return Paths.get(path, new String[0]).toUri().toString();
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public static String toUrl(String path) throws MalformedURLException {
        File file = new File(path);
        return file.toURI().toURL().toString();
    }

    public static boolean isUri(String uriString) {
        try {
            URI uri = new URI(uriString);
            return StringUtils.isNotBlank((CharSequence)uri.getScheme());
        }
        catch (IllegalArgumentException | SecurityException | URISyntaxException | FileSystemNotFoundException e) {
            return false;
        }
    }

    public static Messages.Response setErrorResponse(Messages.Response response, ErrorCode errorCode, String errorMessage) {
        response.body = new Responses.ErrorResponseBody(new Types.Message(errorCode.getId(), errorMessage));
        response.message = errorMessage;
        response.success = false;
        return response;
    }

    public static Messages.Response setErrorResponse(Messages.Response response, ErrorCode errorCode, Exception e) {
        String errorMessage = e.toString();
        response.body = new Responses.ErrorResponseBody(new Types.Message(errorCode.getId(), errorMessage));
        response.message = errorMessage;
        response.success = false;
        return response;
    }

    public static CompletableFuture<Messages.Response> createAsyncErrorResponse(Messages.Response response, ErrorCode errorCode, String errorMessage) {
        return CompletableFuture.completedFuture(AdapterUtils.setErrorResponse(response, errorCode, errorMessage));
    }

    public static CompletableFuture<Messages.Response> createAsyncErrorResponse(Messages.Response response, ErrorCode errorCode, Exception e) {
        return CompletableFuture.completedFuture(AdapterUtils.setErrorResponse(response, errorCode, e));
    }

    public static CompletionException createCompletionException(String message, ErrorCode errorCode, Throwable cause) {
        return new CompletionException(new DebugException(message, cause, errorCode.getId()));
    }

    public static CompletionException createCompletionException(String message, ErrorCode errorCode) {
        return new CompletionException(new DebugException(message, errorCode.getId()));
    }

    public static DebugException createUserErrorDebugException(String message, ErrorCode errorCode) {
        return new DebugException(message, errorCode.getId(), true);
    }

    public static String getSHA256HexDigest(String content) {
        byte[] hashBytes = null;
        try {
            hashBytes = MessageDigest.getInstance("SHA-256").digest(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        if (hashBytes != null) {
            for (byte b : hashBytes) {
                buf.append(Integer.toHexString((b & 0xFF) + 256).substring(1));
            }
        }
        return buf.toString();
    }

    public static String decodeURIComponent(String uri) {
        try {
            return URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return uri;
        }
    }

    public static Path generateClasspathJar(String[] classPaths) throws IOException {
        ArrayList<String> classpathUrls = new ArrayList<String>();
        for (String classpath : classPaths) {
            classpathUrls.add(AdapterUtils.toUrl(classpath));
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String classpathValue = String.join((CharSequence)" ", classpathUrls);
        attributes.put(Attributes.Name.CLASS_PATH, classpathValue);
        Path tempfile = AdapterUtils.createTempFile("cp_" + AdapterUtils.getMd5(classpathValue), ".jar");
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(tempfile.toFile()), manifest);
        jar.close();
        return tempfile;
    }

    public static Path generateArgfile(String[] classPaths, String[] modulePaths) throws IOException {
        String argfile = "";
        if (ArrayUtils.isNotEmpty((Object[])classPaths)) {
            argfile = "-classpath \"" + String.join((CharSequence)File.pathSeparator, classPaths) + "\"";
        }
        if (ArrayUtils.isNotEmpty((Object[])modulePaths)) {
            argfile = " --module-path \"" + String.join((CharSequence)File.pathSeparator, modulePaths) + "\"";
        }
        argfile = argfile.replace("\\", "\\\\");
        Path tempfile = AdapterUtils.createTempFile("cp_" + AdapterUtils.getMd5(argfile), ".argfile");
        Files.write(tempfile, argfile.getBytes(), new OpenOption[0]);
        return tempfile;
    }

    private static synchronized Path getTmpDir() throws IOException {
        if (tmpdir == null) {
            try {
                tmpdir = Paths.get(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")), new String[0]);
            }
            catch (NullPointerException | InvalidPathException e) {
                Path tmpfile = Files.createTempFile("", ".tmp", new FileAttribute[0]);
                tmpdir = tmpfile.getParent();
                try {
                    Files.deleteIfExists(tmpfile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return tmpdir;
    }

    private static Path createTempFile(String baseName, String suffix) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        int i = 0;
        while (true) {
            Path tempFile = AdapterUtils.getTmpDir().resolve(baseName + (i == 0 ? "" : Integer.valueOf(i)) + suffix);
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!Files.exists(tempFile, new LinkOption[0])) {
                return Files.createFile(tempFile, new FileAttribute[0]);
            }
            ++i;
        }
    }

    private static String getMd5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger md5 = new BigInteger(1, messageDigest);
            return md5.toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            return Integer.toString(input.hashCode(), 36);
        }
    }
}

