/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.StackFrameUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.StepRequest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RestartFrameHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.RESTARTFRAME);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.RestartFrameArguments restartFrameArgs = (Requests.RestartFrameArguments)arguments;
        StackFrameReference stackFrameReference = (StackFrameReference)context.getRecyclableIdPool().getObjectById(restartFrameArgs.frameId);
        if (stackFrameReference == null) {
            throw AdapterUtils.createCompletionException(String.format("RestartFrame: cannot find the stack frame with frameID %s", restartFrameArgs.frameId), ErrorCode.RESTARTFRAME_FAILURE);
        }
        if (this.canRestartFrame(context, stackFrameReference)) {
            try {
                ThreadReference reference = stackFrameReference.getThread();
                this.popStackFrames(context, reference, stackFrameReference.getDepth());
                this.stepInto(context, reference);
            }
            catch (DebugException de) {
                context.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, de.getMessage()));
                throw AdapterUtils.createCompletionException(String.format("Failed to restart stack frame. Reason: %s", de.getMessage()), ErrorCode.RESTARTFRAME_FAILURE, de);
            }
            return CompletableFuture.completedFuture(response);
        }
        context.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, "Current stack frame doesn't support restart."));
        throw AdapterUtils.createCompletionException("Current stack frame doesn't support restart.", ErrorCode.RESTARTFRAME_FAILURE);
    }

    private boolean canRestartFrame(IDebugAdapterContext context, StackFrameReference frameReference) {
        if (!context.getDebugSession().getVM().canPopFrames()) {
            return false;
        }
        ThreadReference reference = frameReference.getThread();
        StackFrame[] frames = context.getStackFrameManager().reloadStackFrames(reference);
        if (frames.length <= frameReference.getDepth() + 1) {
            return false;
        }
        for (int i = 0; i <= frameReference.getDepth() + 1; ++i) {
            if (!StackFrameUtility.isNative(frames[i])) continue;
            return false;
        }
        return true;
    }

    private void popStackFrames(IDebugAdapterContext context, ThreadReference thread, int depth) throws DebugException {
        StackFrame[] frames = context.getStackFrameManager().reloadStackFrames(thread);
        StackFrameUtility.pop(frames[depth]);
    }

    private void stepInto(IDebugAdapterContext context, ThreadReference thread) {
        StepRequest request = DebugUtility.createStepIntoRequest(thread, context.getStepFilters().allowClasses, context.getStepFilters().skipClasses);
        context.getDebugSession().getEventHub().stepEvents().filter(debugEvent -> request.equals(debugEvent.event.request())).take(1L).subscribe(debugEvent -> {
            debugEvent.shouldResume = false;
            context.getProtocolServer().sendEvent(new Events.ContinuedEvent(thread.uniqueID()));
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("restartframe", thread.uniqueID()));
        });
        request.enable();
        thread.resume();
    }
}

