/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HotCodeReplaceHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.REDEFINECLASSES);
    }

    @Override
    public void initialize(IDebugAdapterContext context) {
        IDebugRequestHandler.super.initialize(context);
        IHotCodeReplaceProvider provider = context.getProvider(IHotCodeReplaceProvider.class);
        provider.getEventHub().subscribe(event -> {
            if (event.getEventType() == HotCodeReplaceEvent.EventType.BUILD_COMPLETE) {
                context.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.BUILD_COMPLETE, event.getMessage()));
            } else if (event.getEventType() == HotCodeReplaceEvent.EventType.STARTING) {
                context.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.STARTING, event.getMessage()));
            } else if (event.getEventType() == HotCodeReplaceEvent.EventType.END) {
                context.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.END, event.getMessage()));
            } else if (event.getEventType() == HotCodeReplaceEvent.EventType.ERROR) {
                context.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.ERROR, event.getMessage()));
            } else if (event.getEventType() == HotCodeReplaceEvent.EventType.WARNING) {
                context.getProtocolServer().sendEvent(new Events.HotCodeReplaceEvent(Events.HotCodeReplaceEvent.ChangeType.WARNING, event.getMessage()));
            }
        });
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        IHotCodeReplaceProvider provider = context.getProvider(IHotCodeReplaceProvider.class);
        return ((CompletableFuture)provider.redefineClasses().thenCompose(classNames -> {
            response.body = new Responses.RedefineClassesResponse(classNames.toArray(new String[0]));
            return CompletableFuture.completedFuture(response);
        })).exceptionally(ex -> {
            String errorMessage = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            response.body = new Responses.RedefineClassesResponse(new String[0], errorMessage);
            return response;
        });
    }
}

