/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.microsoft.java.debug.core.adapter.variables.VariableDetailUtils;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class VariablesRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.VARIABLES);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        variableFormatter = context.getVariableFormatter();
        varArgs = (Requests.VariablesArguments)arguments;
        showStaticVariables = DebugSettings.getCurrent().showStaticVariables;
        options = variableFormatter.getDefaultOptions();
        VariableUtils.applyFormatterOptions(options, varArgs.format != null && varArgs.format.hex != false);
        evaluationEngine = context.getProvider(IEvaluationProvider.class);
        list = new ArrayList<Types.Variable>();
        container = context.getRecyclableIdPool().getObjectById(varArgs.variablesReference);
        if (container == null) {
            response.body = new Responses.VariablesResponseBody(list);
            return CompletableFuture.completedFuture(response);
        }
        if (!(container instanceof VariableProxy)) {
            throw AdapterUtils.createCompletionException(String.format("VariablesRequest: Invalid variablesReference %d.", new Object[]{varArgs.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
        }
        containerNode = (VariableProxy)container;
        childrenList = new ArrayList<E>();
        stackFrameManager = context.getStackFrameManager();
        containerEvaluateName = containerNode.getEvaluateName();
        isUnboundedTypeContainer = containerNode.isUnboundedType();
        if (containerNode.getProxiedVariable() instanceof StackFrameReference) {
            stackFrameReference = (StackFrameReference)containerNode.getProxiedVariable();
            frame = stackFrameManager.getStackFrame(stackFrameReference);
            if (frame == null) {
                throw AdapterUtils.createCompletionException(String.format("Invalid stackframe id %d to get variables.", new Object[]{varArgs.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
            }
            try {
                threadId = stackFrameReference.getThread().uniqueID();
                result = context.getStepResultManager().getMethodResult(threadId);
                if (result != null) {
                    returnIcon = AdapterUtils.isWin != false || AdapterUtils.isMac != false ? "\u23af\u25ba" : "->";
                    childrenList.add(new Variable(returnIcon + result.method.name() + "()", result.value, null));
                }
                childrenList.addAll(VariableUtils.listLocalVariables(frame));
                thisVariable = VariableUtils.getThisVariable(frame);
                if (thisVariable != null) {
                    childrenList.add(thisVariable);
                }
                if (!showStaticVariables || !frame.location().method().isStatic()) ** GOTO lbl88
                childrenList.addAll(VariableUtils.listStaticVariables(frame));
            }
            catch (AbsentInformationException | InternalException | InvalidStackFrameException e) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{e.toString()}), ErrorCode.GET_VARIABLE_FAILURE, e);
            }
        } else {
            try {
                containerObj = (ObjectReference)containerNode.getProxiedVariable();
                if (DebugSettings.getCurrent().showLogicalStructure && evaluationEngine != null) {
                    logicalStructure = null;
                    try {
                        logicalStructure = JavaLogicalStructureManager.getLogicalStructure(containerObj);
                    }
                    catch (Exception e) {
                        VariablesRequestHandler.logger.log(Level.WARNING, "Failed to get the logical structure for the variable, fall back to the Object view.", e);
                    }
                    if (isUnboundedTypeContainer && logicalStructure != null && containerEvaluateName != null) {
                        containerEvaluateName = "((" + logicalStructure.getFullyQualifiedName() + ")" + containerEvaluateName + ")";
                        isUnboundedTypeContainer = false;
                    }
                    while (logicalStructure != null) {
                        valueExpression = logicalStructure.getValueExpression();
                        logicalVariables = logicalStructure.getVariables();
                        try {
                            if (valueExpression != null) {
                                containerEvaluateName = containerEvaluateName == null ? null : containerEvaluateName + "." + valueExpression.evaluateName;
                                isUnboundedTypeContainer = valueExpression.returnUnboundedType;
                                value = logicalStructure.getValue(containerObj, containerNode.getThread(), evaluationEngine);
                                if (value instanceof ObjectReference) {
                                    containerObj = (ObjectReference)value;
                                    logicalStructure = JavaLogicalStructureManager.getLogicalStructure(containerObj);
                                    continue;
                                }
                                childrenList = Arrays.asList(new Variable[]{new Variable("logical structure", (Value)value)});
                            } else if (logicalVariables != null && logicalVariables.length > 0) {
                                for (JavaLogicalStructure.LogicalVariable logicalVariable : logicalVariables) {
                                    name = logicalVariable.getName();
                                    value = logicalVariable.getValue(containerObj, containerNode.getThread(), evaluationEngine);
                                    variable = new Variable(name, value, logicalVariable.getEvaluateName());
                                    variable.setUnboundedType(logicalVariable.returnUnboundedType());
                                    childrenList.add(variable);
                                }
                            }
                        }
                        catch (Exception e) {
                            VariablesRequestHandler.logger.log(Level.WARNING, "Failed to get the logical structure for the variable, fall back to the Object view.", e);
                        }
                        logicalStructure = null;
                    }
                }
                if (childrenList.isEmpty() && VariableUtils.hasChildren(containerObj, showStaticVariables)) {
                    childrenList = varArgs.count > 0 ? VariableUtils.listFieldVariables(containerObj, varArgs.start, varArgs.count) : VariableUtils.listFieldVariables(containerObj, showStaticVariables);
                }
            }
            catch (AbsentInformationException e) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{e.toString()}), ErrorCode.GET_VARIABLE_FAILURE, e);
            }
        }
lbl88:
        // 3 sources

        duplicateNames = this.getDuplicateNames((Collection<String>)childrenList.stream().map((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$0(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)()).collect(Collectors.toList()));
        variableNameMap = new HashMap<K, V>();
        if (!duplicateNames.isEmpty()) {
            duplicateVars = childrenList.stream().filter((Predicate<Variable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$1(java.util.Set com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Z)(duplicateNames)).collect(Collectors.groupingBy((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$2(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)(), Collectors.toList()));
            duplicateVars.forEach((BiConsumer<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handle$3(com.microsoft.java.debug.core.adapter.variables.IVariableFormatter java.util.Map java.util.Map java.lang.String java.util.List ), (Ljava/lang/String;Ljava/util/List;)V)((IVariableFormatter)variableFormatter, options, variableNameMap));
        }
        for (Variable javaVariable : childrenList) {
            value = javaVariable.value;
            name = javaVariable.name;
            if (variableNameMap.containsKey(javaVariable)) {
                name = (String)variableNameMap.get(javaVariable);
            }
            indexedVariables = -1;
            sizeValue = null;
            if (value instanceof ArrayReference) {
                indexedVariables = ((ArrayReference)value).length();
            } else if (value instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && evaluationEngine != null) {
                try {
                    structure = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)value);
                    if (structure != null && structure.getSizeExpression() != null && (sizeValue = structure.getSize((ObjectReference)value, containerNode.getThread(), evaluationEngine)) != null && sizeValue instanceof IntegerValue) {
                        indexedVariables = ((IntegerValue)sizeValue).value();
                    }
                }
                catch (Exception e) {
                    VariablesRequestHandler.logger.log(Level.INFO, "Failed to get the logical size of the variable", e);
                }
            }
            evaluateName = null;
            if (javaVariable.evaluateName == null || containerEvaluateName == null && containerNode.getProxiedVariable() instanceof ObjectReference) {
                evaluateName = null;
            } else if (isUnboundedTypeContainer && !containerNode.isIndexedVariable()) {
                typeName = ((ObjectReference)containerNode.getProxiedVariable()).referenceType().name();
                typeName = typeName.replaceAll("\\$", ".");
                evaluateName = VariableUtils.getEvaluateName(javaVariable.evaluateName, "((" + typeName + ")" + containerEvaluateName + ")", false);
            } else {
                evaluateName = containerEvaluateName != null && containerEvaluateName.contains("%s") != false ? String.format(containerEvaluateName, new Object[]{javaVariable.evaluateName}) : VariableUtils.getEvaluateName(javaVariable.evaluateName, containerEvaluateName, containerNode.isIndexedVariable());
            }
            referenceId = 0;
            if (indexedVariables > 0 || indexedVariables < 0 && value instanceof ObjectReference) {
                varProxy = new VariableProxy(containerNode.getThread(), containerNode.getScope(), value, containerNode, evaluateName);
                referenceId = context.getRecyclableIdPool().addObject(containerNode.getThreadId(), varProxy);
                varProxy.setIndexedVariable(indexedVariables >= 0);
                varProxy.setUnboundedType(javaVariable.isUnboundedType());
            }
            hasErrors = false;
            valueString = null;
            try {
                valueString = variableFormatter.valueToString((Value)value, options);
            }
            catch (OutOfMemoryError e) {
                hasErrors = true;
                VariablesRequestHandler.logger.log(Level.SEVERE, "Failed to convert the value of a large object to a string", e);
                valueString = "<Unable to display the value of a large object>";
            }
            catch (Exception e) {
                hasErrors = true;
                VariablesRequestHandler.logger.log(Level.SEVERE, "Failed to resolve the variable value", e);
                valueString = "<Failed to resolve the variable value due to \"" + e.getMessage() + "\">";
            }
            typeString = "";
            try {
                typeString = variableFormatter.typeToString(value == null ? null : value.type(), options);
            }
            catch (Exception e) {
                VariablesRequestHandler.logger.log(Level.SEVERE, "Failed to resolve the variable type", e);
                typeString = "";
            }
            typedVariables = new Types.Variable(name, valueString, typeString, referenceId, evaluateName);
            typedVariables.indexedVariables = Math.max(indexedVariables, 0);
            detailsValue = null;
            if (!hasErrors) {
                if (sizeValue != null) {
                    detailsValue = "size=" + variableFormatter.valueToString(sizeValue, options);
                } else if (DebugSettings.getCurrent().showToString) {
                    try {
                        detailsValue = VariableDetailUtils.formatDetailsValue((Value)value, containerNode.getThread(), variableFormatter, options, evaluationEngine);
                    }
                    catch (OutOfMemoryError e) {
                        VariablesRequestHandler.logger.log(Level.SEVERE, "Failed to compute the toString() value of a large object", e);
                        detailsValue = "<Unable to display the details of a large object>";
                    }
                    catch (Exception e) {
                        VariablesRequestHandler.logger.log(Level.SEVERE, "Failed to compute the toString() value", e);
                        detailsValue = "<Failed to resolve the variable details due to \"" + e.getMessage() + "\">";
                    }
                }
            }
            if (detailsValue != null) {
                typedVariables.value = typedVariables.value + " " + detailsValue;
            }
            list.add(typedVariables);
        }
        if (list.isEmpty() && containerNode.getProxiedVariable() instanceof ObjectReference) {
            list.add(new Types.Variable("Class has no fields", "", null, 0, null));
        }
        response.body = new Responses.VariablesResponseBody(list);
        return CompletableFuture.completedFuture(response);
    }

    private Set<String> getDuplicateNames(Collection<String> list) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> set = new HashSet<String>();
        for (String item : list) {
            if (!set.contains(item)) {
                set.add(item);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private static /* synthetic */ void lambda$handle$3(IVariableFormatter variableFormatter, Map options, Map variableNameMap, String k, List duplicateVariables) {
        Type declarationType;
        HashSet<String> declarationTypeNames = new HashSet<String>();
        boolean declarationTypeNameConflict = false;
        for (Variable javaVariable : duplicateVariables) {
            declarationType = javaVariable.getDeclaringType();
            if (declarationType == null) continue;
            String declarationTypeName = variableFormatter.typeToString(declarationType, options);
            String compositeName = String.format("%s (%s)", javaVariable.name, declarationTypeName);
            if (!declarationTypeNames.add(compositeName)) {
                declarationTypeNameConflict = true;
                break;
            }
            variableNameMap.put(javaVariable, compositeName);
        }
        if (declarationTypeNameConflict) {
            for (Variable javaVariable : duplicateVariables) {
                declarationType = javaVariable.getDeclaringType();
                if (declarationType == null) continue;
                variableNameMap.put(javaVariable, String.format("%s (%s)", javaVariable.name, declarationType.name()));
            }
        }
    }

    private static /* synthetic */ String lambda$handle$2(Variable var) {
        return var.name;
    }

    private static /* synthetic */ boolean lambda$handle$1(Set duplicateNames, Variable var) {
        return duplicateNames.contains(var.name);
    }

    private static /* synthetic */ String lambda$handle$0(Variable var) {
        return var.name;
    }
}

