/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.LaunchException;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.ProcessConsole;
import com.microsoft.java.debug.core.adapter.handler.ILaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchUtils;
import com.microsoft.java.debug.core.adapter.handler.LaunchWithDebuggingDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchWithoutDebuggingDelegate;
import com.microsoft.java.debug.core.adapter.handler.StackTraceRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.VMDisconnectEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LaunchRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;
    protected ILaunchDelegate activeLaunchHandler;
    private CompletableFuture<Boolean> waitForDebuggeeConsole = new CompletableFuture();
    private static final Pattern STACKTRACE_PATTERN = Pattern.compile("\\s+at\\s+([\\w$\\.]+\\/)?(([\\w$]+\\.)+[<\\w$>]+)\\(([\\w-$]+\\.java:\\d+)\\)");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.LAUNCH);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        this.activeLaunchHandler = launchArguments.noDebug ? new LaunchWithoutDebuggingDelegate(daContext -> this.handleTerminatedEvent((IDebugAdapterContext)daContext)) : new LaunchWithDebuggingDelegate();
        return this.handleLaunchCommand(arguments, response, context);
    }

    protected CompletableFuture<Messages.Response> handleLaunchCommand(Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        if (StringUtils.isBlank((CharSequence)launchArguments.mainClass) || ArrayUtils.isEmpty((Object[])launchArguments.modulePaths) && ArrayUtils.isEmpty((Object[])launchArguments.classPaths)) {
            throw AdapterUtils.createCompletionException("Failed to launch debuggee VM. Missing mainClass or modulePaths/classPaths options in launch configuration.", ErrorCode.ARGUMENT_MISSING);
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.encoding)) {
            if (!Charset.isSupported(launchArguments.encoding)) {
                throw AdapterUtils.createCompletionException("Failed to launch debuggee VM. 'encoding' options in the launch configuration is not recognized.", ErrorCode.INVALID_ENCODING);
            }
            context.setDebuggeeEncoding(Charset.forName(launchArguments.encoding));
            launchArguments.vmArgs = StringUtils.isBlank((CharSequence)launchArguments.vmArgs) ? String.format("-Dfile.encoding=%s", context.getDebuggeeEncoding().name()) : String.format("%s -Dfile.encoding=%s", launchArguments.vmArgs, context.getDebuggeeEncoding().name());
        }
        context.setLaunchMode(launchArguments.noDebug ? LaunchMode.NO_DEBUG : LaunchMode.DEBUG);
        this.activeLaunchHandler.preLaunch(launchArguments, context);
        if (launchArguments.shortenCommandLine == Requests.ShortenApproach.JARMANIFEST) {
            if (ArrayUtils.isNotEmpty((Object[])launchArguments.classPaths)) {
                try {
                    Path tempfile = LaunchUtils.generateClasspathJar(launchArguments.classPaths);
                    launchArguments.vmArgs = launchArguments.vmArgs + " -cp \"" + tempfile.toAbsolutePath().toString() + "\"";
                    launchArguments.classPaths = new String[0];
                    context.setClasspathJar(tempfile);
                }
                catch (IllegalArgumentException | MalformedURLException ex) {
                    logger.log(Level.SEVERE, String.format("Failed to launch the program with jarmanifest style: %s", ex.toString(), ex));
                    throw AdapterUtils.createCompletionException("Failed to launch the program with jarmanifest style: " + ex.toString(), ErrorCode.LAUNCH_FAILURE, ex);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, String.format("Failed to create a temp classpath.jar: %s", e.toString()), e);
                }
            }
        } else if (launchArguments.shortenCommandLine == Requests.ShortenApproach.ARGFILE) {
            try {
                Path tempfile = LaunchUtils.generateArgfile(launchArguments.classPaths, launchArguments.modulePaths);
                launchArguments.vmArgs = launchArguments.vmArgs + " \"@" + tempfile.toAbsolutePath().toString() + "\"";
                launchArguments.classPaths = new String[0];
                launchArguments.modulePaths = new String[0];
                context.setArgsfile(tempfile);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, String.format("Failed to create a temp argfile: %s", e.toString()), e);
            }
        }
        return this.launch(launchArguments, response, context).thenCompose(res -> {
            IDebugSession debugSession;
            long processId = context.getProcessId();
            long shellProcessId = context.getShellProcessId();
            if (context.getDebuggeeProcess() != null) {
                processId = context.getDebuggeeProcess().pid();
            }
            if (processId > 0L || shellProcessId > 0L) {
                context.getProtocolServer().sendEvent(new Events.ProcessIdNotification(processId, shellProcessId));
            }
            LaunchUtils.releaseTempLaunchFile(context.getClasspathJar());
            LaunchUtils.releaseTempLaunchFile(context.getArgsfile());
            if (res.success) {
                this.activeLaunchHandler.postLaunch(launchArguments, context);
            }
            if ((debugSession = context.getDebugSession()) != null) {
                debugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof VMDisconnectEvent).subscribe(debugEvent -> {
                    context.setVmTerminated();
                    try {
                        debugSession.getEventHub().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.handleTerminatedEvent(context);
                });
            }
            return CompletableFuture.completedFuture(res);
        });
    }

    protected void handleTerminatedEvent(IDebugAdapterContext context) {
        CompletableFuture.runAsync(() -> {
            try {
                this.waitForDebuggeeConsole.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            context.getProtocolServer().sendEvent(new Events.TerminatedEvent());
        });
    }

    public static String[] constructLaunchCommands(Requests.LaunchArguments launchArguments, boolean serverMode, String address) {
        String[] mainClasses;
        ArrayList<String> launchCmds = new ArrayList<String>();
        if (launchArguments.launcherScript != null) {
            launchCmds.add(launchArguments.launcherScript);
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.javaExec)) {
            launchCmds.add(launchArguments.javaExec);
        } else {
            String javaHome = StringUtils.isNotEmpty((CharSequence)DebugSettings.getCurrent().javaHome) ? DebugSettings.getCurrent().javaHome : System.getProperty("java.home");
            launchCmds.add(Paths.get(javaHome, "bin", "java").toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            launchCmds.add(String.format("-agentlib:jdwp=transport=dt_socket,server=%s,suspend=y,address=%s", serverMode ? "y" : "n", address));
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.vmArgs)) {
            launchCmds.addAll(DebugUtility.parseArguments(launchArguments.vmArgs));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.modulePaths)) {
            launchCmds.add("--module-path");
            launchCmds.add(String.join((CharSequence)File.pathSeparator, launchArguments.modulePaths));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.classPaths)) {
            launchCmds.add("-cp");
            launchCmds.add(String.join((CharSequence)File.pathSeparator, launchArguments.classPaths));
        }
        if ((mainClasses = launchArguments.mainClass.split("/")).length == 2) {
            launchCmds.add("-m");
        }
        launchCmds.add(launchArguments.mainClass);
        if (StringUtils.isNotBlank((CharSequence)launchArguments.args)) {
            launchCmds.addAll(DebugUtility.parseArguments(launchArguments.args));
        }
        return launchCmds.toArray(new String[0]);
    }

    protected CompletableFuture<Messages.Response> launch(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        logger.info("Trying to launch Java Program with options:\n" + String.format("main-class: %s\n", launchArguments.mainClass) + String.format("args: %s\n", launchArguments.args) + String.format("module-path: %s\n", StringUtils.join((Object[])launchArguments.modulePaths, (String)File.pathSeparator)) + String.format("class-path: %s\n", StringUtils.join((Object[])launchArguments.classPaths, (String)File.pathSeparator)) + String.format("vmArgs: %s", launchArguments.vmArgs));
        if (context.supportsRunInTerminalRequest() && (launchArguments.console == Requests.CONSOLE.integratedTerminal || launchArguments.console == Requests.CONSOLE.externalTerminal)) {
            this.waitForDebuggeeConsole.complete(true);
            return this.activeLaunchHandler.launchInTerminal(launchArguments, response, context);
        }
        CompletableFuture<Messages.Response> resultFuture = new CompletableFuture<Messages.Response>();
        try {
            Process debuggeeProcess = this.activeLaunchHandler.launch(launchArguments, context);
            context.setDebuggeeProcess(debuggeeProcess);
            ProcessConsole debuggeeConsole = new ProcessConsole(debuggeeProcess, "Debuggee", context.getDebuggeeEncoding());
            debuggeeConsole.lineMessages().map(message -> LaunchRequestHandler.convertToOutputEvent(message.output, message.category, context)).doFinally(() -> this.waitForDebuggeeConsole.complete(true)).subscribe(event -> context.getProtocolServer().sendEvent((Events.DebugEvent)event));
            debuggeeConsole.start();
            resultFuture.complete(response);
        }
        catch (LaunchException e) {
            Events.OutputEvent event2;
            if (StringUtils.isNotBlank((CharSequence)e.getStdout())) {
                event2 = LaunchRequestHandler.convertToOutputEvent(e.getStdout(), Events.OutputEvent.Category.stdout, context);
                context.getProtocolServer().sendEvent(event2);
            }
            if (StringUtils.isNotBlank((CharSequence)e.getStderr())) {
                event2 = LaunchRequestHandler.convertToOutputEvent(e.getStderr(), Events.OutputEvent.Category.stderr, context);
                context.getProtocolServer().sendEvent(event2);
            }
            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee VM. Reason: %s", e.getMessage()), ErrorCode.LAUNCH_FAILURE.getId()));
        }
        catch (IllegalConnectorArgumentsException | VMStartException | IOException e) {
            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee VM. Reason: %s", e.toString()), ErrorCode.LAUNCH_FAILURE.getId()));
        }
        return resultFuture;
    }

    private static Events.OutputEvent convertToOutputEvent(String message, Events.OutputEvent.Category category, IDebugAdapterContext context) {
        Matcher matcher = STACKTRACE_PATTERN.matcher(message);
        if (matcher.find()) {
            String methodField = matcher.group(2);
            String locationField = matcher.group(matcher.groupCount());
            String fullyQualifiedName = methodField.substring(0, methodField.lastIndexOf("."));
            String packageName = fullyQualifiedName.lastIndexOf(".") > -1 ? fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(".")) : "";
            String[] locations = locationField.split(":");
            String sourceName = locations[0];
            int lineNumber = Integer.parseInt(locations[1]);
            String sourcePath = StringUtils.isBlank((CharSequence)packageName) ? sourceName : packageName.replace('.', File.separatorChar) + File.separatorChar + sourceName;
            Types.Source source = null;
            try {
                source = StackTraceRequestHandler.convertDebuggerSourceToClient(fullyQualifiedName, sourceName, sourcePath, context);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new Events.OutputEvent(category, message, source, lineNumber);
        }
        return new Events.OutputEvent(category, message);
    }

    protected static String[] constructEnvironmentVariables(Requests.LaunchArguments launchArguments) {
        String[] envVars = null;
        if (launchArguments.env != null && !launchArguments.env.isEmpty()) {
            HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
            ArrayList<String> duplicated = new ArrayList<String>();
            for (Map.Entry<String, String> entry : launchArguments.env.entrySet()) {
                if (environment.containsKey(entry.getKey())) {
                    duplicated.add(entry.getKey());
                }
                environment.put(entry.getKey(), entry.getValue());
            }
            if (!duplicated.isEmpty()) {
                logger.warning(String.format("There are duplicated environment variables. The values specified in launch.json will be used. Here are the duplicated entries: %s.", String.join((CharSequence)",", duplicated)));
            }
            envVars = new String[environment.size()];
            int i = 0;
            for (Map.Entry entry : environment.entrySet()) {
                envVars[i++] = (String)entry.getKey() + "=" + (String)entry.getValue();
            }
        }
        return envVars;
    }

    public static String parseMainClassWithoutModuleName(String mainClass) {
        int index = mainClass.indexOf(47);
        return mainClass.substring(index + 1);
    }
}

