/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang3.ArrayUtils;

public class LaunchUtils {
    private static Set<Path> tempFilesInUse = new HashSet<Path>();
    private static Path tmpdir = null;

    public static synchronized Path generateClasspathJar(String[] classPaths) throws IOException {
        ArrayList<String> classpathUrls = new ArrayList<String>();
        for (String classpath : classPaths) {
            classpathUrls.add(AdapterUtils.toUrl(classpath));
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String classpathValue = String.join((CharSequence)" ", classpathUrls);
        attributes.put(Attributes.Name.CLASS_PATH, classpathValue);
        String baseName = "cp_" + LaunchUtils.getMd5(classpathValue);
        LaunchUtils.cleanupTempFiles(baseName, ".jar");
        Path tempfile = LaunchUtils.createTempFile(baseName, ".jar");
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(tempfile.toFile()), manifest);
        jar.close();
        LaunchUtils.lockTempLaunchFile(tempfile);
        return tempfile;
    }

    public static synchronized Path generateArgfile(String[] classPaths, String[] modulePaths) throws IOException {
        Object argfile = "";
        if (ArrayUtils.isNotEmpty((Object[])classPaths)) {
            argfile = "-cp \"" + String.join((CharSequence)File.pathSeparator, classPaths) + "\"";
        }
        if (ArrayUtils.isNotEmpty((Object[])modulePaths)) {
            argfile = (String)argfile + " --module-path \"" + String.join((CharSequence)File.pathSeparator, modulePaths) + "\"";
        }
        argfile = ((String)argfile).replace("\\", "\\\\");
        String baseName = "cp_" + LaunchUtils.getMd5((String)argfile);
        LaunchUtils.cleanupTempFiles(baseName, ".argfile");
        Path tempfile = LaunchUtils.createTempFile(baseName, ".argfile");
        Files.write(tempfile, ((String)argfile).getBytes(), new OpenOption[0]);
        LaunchUtils.lockTempLaunchFile(tempfile);
        return tempfile;
    }

    public static void lockTempLaunchFile(Path tempFile) {
        if (tempFile != null) {
            tempFilesInUse.add(tempFile);
        }
    }

    public static void releaseTempLaunchFile(Path tempFile) {
        if (tempFile != null) {
            tempFilesInUse.remove(tempFile);
        }
    }

    private static synchronized Path getTmpDir() throws IOException {
        if (tmpdir == null) {
            Path tmpfile = Files.createTempFile("", UUID.randomUUID().toString(), new FileAttribute[0]);
            tmpdir = tmpfile.getParent();
            try {
                Files.deleteIfExists(tmpfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpdir;
    }

    private static void cleanupTempFiles(String baseName, String suffix) throws IOException {
        int i = 0;
        while (true) {
            Path tempFile;
            if (!tempFilesInUse.contains(tempFile = LaunchUtils.getTmpDir().resolve(baseName + (Serializable)(i == 0 ? "" : Integer.valueOf(i)) + suffix))) {
                if (!Files.exists(tempFile, new LinkOption[0])) break;
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private static Path createTempFile(String baseName, String suffix) throws IOException {
        int i = 0;
        Path tempFile;
        while (Files.exists(tempFile = LaunchUtils.getTmpDir().resolve(baseName + (Serializable)(i == 0 ? "" : Integer.valueOf(i)) + suffix), new LinkOption[0])) {
            ++i;
        }
        return Files.createFile(tempFile, new FileAttribute[0]);
    }

    private static String getMd5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger md5 = new BigInteger(1, messageDigest);
            return md5.toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            return Integer.toString(input.hashCode(), 36);
        }
    }
}

