/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManagerProvider;
import com.microsoft.java.debug.core.adapter.handler.VMHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class AttachRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");
    private VMHandler vmHandler = new VMHandler();

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.ATTACH);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.AttachArguments attachArguments = (Requests.AttachArguments)arguments;
        context.setAttached(true);
        context.setSourcePaths(attachArguments.sourcePaths);
        context.setDebuggeeEncoding(StandardCharsets.UTF_8);
        context.setStepFilters(attachArguments.stepFilters);
        IVirtualMachineManagerProvider vmProvider = context.getProvider(IVirtualMachineManagerProvider.class);
        this.vmHandler.setVmProvider(vmProvider);
        IDebugSession debugSession = null;
        try {
            logger.info(String.format("Trying to attach to remote debuggee VM %s:%d .", attachArguments.hostName, attachArguments.port));
            debugSession = DebugUtility.attach(vmProvider.getVirtualMachineManager(), attachArguments.hostName, attachArguments.port, attachArguments.timeout);
            context.setDebugSession(debugSession);
            this.vmHandler.connectVirtualMachine(debugSession.getVM());
            logger.info("Attaching to debuggee VM succeeded.");
        }
        catch (IllegalConnectorArgumentsException | IOException e) {
            throw AdapterUtils.createCompletionException(String.format("Failed to attach to remote debuggee VM. Reason: %s", e.toString()), ErrorCode.ATTACH_FAILURE, e);
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("debuggeeEncoding", context.getDebuggeeEncoding());
        if (attachArguments.projectName != null) {
            options.put("projectName", attachArguments.projectName);
        }
        ISourceLookUpProvider sourceProvider = context.getProvider(ISourceLookUpProvider.class);
        sourceProvider.initialize(context, options);
        if (debugSession != null) {
            String debuggeeVersion = debugSession.getVM().version();
            String debuggerVersion = sourceProvider.getJavaRuntimeVersion(attachArguments.projectName);
            if (StringUtils.isNotBlank((CharSequence)debuggerVersion) && !debuggerVersion.equals(debuggeeVersion)) {
                String warnMessage = String.format("[Warn] The debugger and the debuggee are running in different versions of JVMs. You could see wrong source mapping results.\nDebugger JVM version: %s\nDebuggee JVM version: %s", debuggerVersion, debuggeeVersion);
                logger.warning(warnMessage);
                context.getProtocolServer().sendEvent(Events.OutputEvent.createConsoleOutput(warnMessage));
            }
        }
        IEvaluationProvider evaluationProvider = context.getProvider(IEvaluationProvider.class);
        evaluationProvider.initialize(context, options);
        IHotCodeReplaceProvider hcrProvider = context.getProvider(IHotCodeReplaceProvider.class);
        hcrProvider.initialize(context, options);
        ICompletionsProvider completionsProvider = context.getProvider(ICompletionsProvider.class);
        completionsProvider.initialize(context, options);
        context.getProtocolServer().sendEvent(new Events.InitializedEvent());
        return CompletableFuture.completedFuture(response);
    }
}

