/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IdCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecyclableObjectPool<O, V> {
    private final IdCollection<V> objectCollection = new IdCollection();
    private final Map<V, Set<O>> referenceMap = new HashMap<V, Set<O>>();
    private final Map<V, Integer> objectIdMap = new HashMap<V, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addObject(O owner, V object) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("Null object cannot be added.");
        }
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            if (!this.referenceMap.containsKey(object)) {
                HashSet<O> owners = new HashSet<O>(1);
                owners.add(owner);
                this.referenceMap.put(object, (Set<O>)owners);
                int id = this.objectCollection.create(object);
                this.objectIdMap.put((Integer)object, id);
                return id;
            }
            this.referenceMap.get(object).add(owner);
            return this.objectIdMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getObjectById(int id) {
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            return this.objectCollection.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObjectById(int id) {
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            V object = this.objectCollection.remove(id);
            if (object == null) {
                return false;
            }
            this.referenceMap.remove(object);
            this.objectIdMap.remove(object);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObjectsByOwner(O owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null.");
        }
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            ArrayList recycling = new ArrayList();
            this.referenceMap.forEach((key, value) -> {
                if (value.remove(owner) && value.isEmpty()) {
                    recycling.add(key);
                }
            });
            for (Object recycled : recycling) {
                this.objectCollection.remove(this.objectIdMap.remove(recycled));
                this.referenceMap.remove(recycled);
            }
            return !recycling.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllObjects() {
        RecyclableObjectPool recyclableObjectPool = this;
        synchronized (recyclableObjectPool) {
            this.objectCollection.reset();
            this.referenceMap.clear();
            this.objectIdMap.clear();
        }
    }
}

