/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class Breakpoint
implements IBreakpoint {
    private VirtualMachine vm = null;
    private IEventHub eventHub = null;
    private String className = null;
    private int lineNumber = 0;
    private int hitCount = 0;
    private String condition = null;
    private String logMessage = null;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private String methodSignature = null;
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber) {
        this(vm, eventHub, className, lineNumber, 0, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount) {
        this(vm, eventHub, className, lineNumber, hitCount, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition) {
        this.vm = vm;
        this.eventHub = eventHub;
        if (className != null && className.contains("#")) {
            this.className = className.substring(0, className.indexOf("#"));
            this.methodSignature = className.substring(className.indexOf("#") + 1);
        } else {
            this.className = className;
        }
        this.lineNumber = lineNumber;
        this.hitCount = hitCount;
        this.condition = condition;
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition, String logMessage) {
        this(vm, eventHub, className, lineNumber, hitCount, condition);
        this.logMessage = logMessage;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(subscription -> subscription.dispose());
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IBreakpoint)) {
            return super.equals(obj);
        }
        IBreakpoint breakpoint = (IBreakpoint)obj;
        return Objects.equals(this.className(), breakpoint.className()) && this.getLineNumber() == breakpoint.getLineNumber();
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
        Observable.fromIterable(this.requests()).filter(request -> request instanceof BreakpointRequest).subscribe(request -> {
            request.addCountFilter(hitCount);
            request.enable();
        });
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    @Override
    public String getLogMessage() {
        return this.logMessage;
    }

    @Override
    public CompletableFuture<IBreakpoint> install() {
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className);
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        ClassPrepareRequest localClassPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        localClassPrepareRequest.addClassFilter(this.className + "$*");
        localClassPrepareRequest.enable();
        this.requests.add(localClassPrepareRequest);
        CompletableFuture<IBreakpoint> future = new CompletableFuture<IBreakpoint>();
        Disposable subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && (classPrepareRequest.equals(debugEvent.event.request()) || localClassPrepareRequest.equals(debugEvent.event.request()))).subscribe(debugEvent -> {
            ClassPrepareEvent event = (ClassPrepareEvent)debugEvent.event;
            List<BreakpointRequest> newRequests = this.createBreakpointRequests(event.referenceType(), this.lineNumber, this.hitCount, false);
            this.requests.addAll(newRequests);
            if (!newRequests.isEmpty() && !future.isDone()) {
                this.putProperty("verified", true);
                future.complete(this);
            }
        });
        this.subscriptions.add(subscription);
        List<ReferenceType> refTypes = this.vm.classesByName(this.className);
        List<BreakpointRequest> newRequests = this.createBreakpointRequests(refTypes, this.lineNumber, this.hitCount, true);
        this.requests.addAll(newRequests);
        if (!newRequests.isEmpty() && !future.isDone()) {
            this.putProperty("verified", true);
            future.complete(this);
        }
        return future;
    }

    private static List<Location> collectLocations(ReferenceType refType, int lineNumber) {
        ArrayList<Location> locations = new ArrayList<Location>();
        try {
            locations.addAll(refType.locationsOfLine(lineNumber));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locations;
    }

    private static List<Location> collectLocations(List<ReferenceType> refTypes, int lineNumber, boolean includeNestedTypes) {
        ArrayList<Location> locations = new ArrayList<Location>();
        try {
            refTypes.forEach(refType -> {
                List<Location> newLocations = Breakpoint.collectLocations(refType, lineNumber);
                if (!newLocations.isEmpty()) {
                    locations.addAll(newLocations);
                } else if (includeNestedTypes) {
                    for (ReferenceType nestedType : refType.nestedTypes()) {
                        List<Location> nestedLocations = Breakpoint.collectLocations(nestedType, lineNumber);
                        if (nestedLocations.isEmpty()) continue;
                        locations.addAll(nestedLocations);
                        break;
                    }
                }
            });
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return locations;
    }

    private static List<Location> collectLocations(List<ReferenceType> refTypes, String nameAndSignature) {
        ArrayList<Location> locations = new ArrayList<Location>();
        String[] segments = nameAndSignature.split("#");
        block0: for (ReferenceType refType : refTypes) {
            List<Method> methods = refType.methods();
            for (Method method : methods) {
                if (method.isAbstract() || method.isNative() || !segments[0].equals(method.name()) || !segments[1].equals(method.genericSignature()) && !segments[1].equals(method.signature())) continue;
                locations.add(method.location());
                continue block0;
            }
        }
        return locations;
    }

    private List<BreakpointRequest> createBreakpointRequests(ReferenceType refType, int lineNumber, int hitCount, boolean includeNestedTypes) {
        ArrayList<ReferenceType> refTypes = new ArrayList<ReferenceType>();
        refTypes.add(refType);
        return this.createBreakpointRequests(refTypes, lineNumber, hitCount, includeNestedTypes);
    }

    private List<BreakpointRequest> createBreakpointRequests(List<ReferenceType> refTypes, int lineNumber, int hitCount, boolean includeNestedTypes) {
        List<Location> locations = this.methodSignature != null ? Breakpoint.collectLocations(refTypes, this.methodSignature) : Breakpoint.collectLocations(refTypes, lineNumber, includeNestedTypes);
        ArrayList existingLocations = new ArrayList(this.requests.size());
        Observable.fromIterable(this.requests).filter(request -> request instanceof BreakpointRequest).map(request -> ((BreakpointRequest)request).location()).toList().subscribe(list -> existingLocations.addAll(list));
        ArrayList newLocations = new ArrayList(locations.size());
        Observable.fromIterable(locations).filter(location -> !existingLocations.contains(location)).toList().subscribe(list -> newLocations.addAll(list));
        ArrayList<BreakpointRequest> newRequests = new ArrayList<BreakpointRequest>(newLocations.size());
        newLocations.forEach(location -> {
            try {
                BreakpointRequest request = this.vm.eventRequestManager().createBreakpointRequest((Location)location);
                request.setSuspendPolicy(1);
                if (hitCount > 0) {
                    request.addCountFilter(hitCount);
                }
                request.enable();
                request.putProperty("functional", this.methodSignature != null);
                newRequests.add(request);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        });
        return newRequests;
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.propertyMap.put(key, value);
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertyMap.get(key);
    }
}

