/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.EvaluatableBreakpoint;
import com.microsoft.java.debug.core.EventHub;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.IMethodBreakpoint;
import com.microsoft.java.debug.core.IWatchpoint;
import com.microsoft.java.debug.core.MethodBreakpoint;
import com.microsoft.java.debug.core.Watchpoint;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.ArrayList;
import java.util.List;

public class DebugSession
implements IDebugSession {
    private VirtualMachine vm;
    private EventHub eventHub = new EventHub();

    public DebugSession(VirtualMachine virtualMachine) {
        this.vm = virtualMachine;
    }

    @Override
    public void start() {
        ThreadStartRequest threadStartRequest = this.vm.eventRequestManager().createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = this.vm.eventRequestManager().createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
        this.eventHub.start(this.vm);
    }

    @Override
    public void suspend() {
        this.vm.suspend();
    }

    @Override
    public void resume() {
        for (ThreadReference tr : DebugUtility.getAllThreadsSafely(this)) {
            try {
                while (tr.suspendCount() > 1) {
                    tr.resume();
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
        }
        this.vm.resume();
    }

    @Override
    public void detach() {
        this.vm.dispose();
    }

    @Override
    public void terminate() {
        if (this.vm.process() == null || this.vm.process().isAlive()) {
            this.vm.exit(0);
        }
    }

    @Override
    public IBreakpoint createBreakpoint(String className, int lineNumber, int hitCount, String condition, String logMessage) {
        return new EvaluatableBreakpoint(this.vm, this.getEventHub(), className, lineNumber, hitCount, condition, logMessage);
    }

    @Override
    public IWatchpoint createWatchPoint(String className, String fieldName, String accessType, String condition, int hitCount) {
        return new Watchpoint(this.vm, this.getEventHub(), className, fieldName, accessType, condition, hitCount);
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught) {
        this.setExceptionBreakpoints(notifyCaught, notifyUncaught, null, null);
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught, String[] classFilters, String[] classExclusionFilters) {
        EventRequestManager manager = this.vm.eventRequestManager();
        ArrayList<ExceptionRequest> legacy = new ArrayList<ExceptionRequest>(manager.exceptionRequests());
        manager.deleteEventRequests(legacy);
        if (notifyCaught || notifyUncaught) {
            this.vm.allThreads();
            ExceptionRequest request = manager.createExceptionRequest(null, notifyCaught, notifyUncaught);
            request.setSuspendPolicy(1);
            if (classFilters != null) {
                for (String classFilter : classFilters) {
                    request.addClassFilter(classFilter);
                }
            }
            if (classExclusionFilters != null) {
                for (String exclusionFilter : classExclusionFilters) {
                    request.addClassExclusionFilter(exclusionFilter);
                }
            }
            request.enable();
        }
    }

    @Override
    public Process process() {
        return this.vm.process();
    }

    @Override
    public List<ThreadReference> getAllThreads() {
        return this.vm.allThreads();
    }

    @Override
    public IEventHub getEventHub() {
        return this.eventHub;
    }

    @Override
    public VirtualMachine getVM() {
        return this.vm;
    }

    @Override
    public IMethodBreakpoint createFunctionBreakpoint(String className, String functionName, String condition, int hitCount) {
        return new MethodBreakpoint(this.vm, this.getEventHub(), className, functionName, condition, hitCount);
    }
}

