/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.microsoft.java.debug.core.adapter.variables.VariableDetailUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;

public class InlineValuesRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.INLINEVALUES);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.InlineValuesArguments inlineValuesArgs = (Requests.InlineValuesArguments)arguments;
        int variableCount = inlineValuesArgs == null || inlineValuesArgs.variables == null ? 0 : inlineValuesArgs.variables.length;
        Requests.InlineVariable[] inlineVariables = inlineValuesArgs.variables;
        StackFrameReference stackFrameReference = (StackFrameReference)context.getRecyclableIdPool().getObjectById(inlineValuesArgs.frameId);
        if (stackFrameReference == null) {
            logger.log(Level.SEVERE, String.format("InlineValues failed: invalid stackframe id %d.", inlineValuesArgs.frameId));
            response.body = new Responses.InlineValuesResponse(null);
            return CompletableFuture.completedFuture(response);
        }
        if (!context.isLocalDebugging() && context.asyncJDWP()) {
            response.body = new Responses.InlineValuesResponse(null);
            return CompletableFuture.completedFuture(response);
        }
        IStackFrameManager stackFrameManager = context.getStackFrameManager();
        StackFrame frame = stackFrameManager.getStackFrame(stackFrameReference);
        if (frame == null) {
            logger.log(Level.SEVERE, String.format("InlineValues failed: stale stackframe id %d.", inlineValuesArgs.frameId));
            response.body = new Responses.InlineValuesResponse(null);
            return CompletableFuture.completedFuture(response);
        }
        Variable[] values = new Variable[variableCount];
        try {
            if (InlineValuesRequestHandler.isLambdaFrame(frame)) {
                StackFrame syntheticLambdaFrame = stackFrameReference.getThread().frame(stackFrameReference.getDepth() + 1);
                this.resolveValuesFromThisVariable(syntheticLambdaFrame.thisObject(), inlineVariables, values, true);
            }
            this.resolveValuesFromThisVariable(frame.thisObject(), inlineVariables, values, false);
        }
        catch (Exception syntheticLambdaFrame) {
            // empty catch block
        }
        Types.Variable[] result = new Types.Variable[variableCount];
        IVariableFormatter variableFormatter = context.getVariableFormatter();
        Map<String, Object> formatterOptions = variableFormatter.getDefaultOptions();
        HashMap<Requests.InlineVariable, Types.Variable> calculatedValues = new HashMap<Requests.InlineVariable, Types.Variable>();
        IEvaluationProvider evaluationEngine = context.getProvider(IEvaluationProvider.class);
        for (int i = 0; i < variableCount; ++i) {
            if (values[i] == null) continue;
            if (calculatedValues.containsKey(inlineVariables[i])) {
                result[i] = (Types.Variable)calculatedValues.get(inlineVariables[i]);
                continue;
            }
            Value value = values[i].value;
            String name = values[i].name;
            int indexedVariables = -1;
            Value sizeValue = null;
            if (value instanceof ArrayReference) {
                indexedVariables = ((ArrayReference)value).length();
            } else if (value instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && evaluationEngine != null) {
                try {
                    JavaLogicalStructure structure = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)value);
                    if (structure != null && structure.getSizeExpression() != null && (sizeValue = structure.getSize((ObjectReference)value, frame.thread(), evaluationEngine)) != null && sizeValue instanceof IntegerValue) {
                        indexedVariables = ((IntegerValue)sizeValue).value();
                    }
                }
                catch (IllegalArgumentException | InterruptedException | UnsupportedOperationException | CancellationException | ExecutionException e) {
                    logger.log(Level.INFO, String.format("Failed to get the logical size for the type %s.", value.type().name()), e);
                }
            }
            Types.Variable formattedVariable = new Types.Variable(name, variableFormatter.valueToString(value, formatterOptions));
            formattedVariable.indexedVariables = Math.max(indexedVariables, 0);
            Object detailsValue = null;
            if (sizeValue != null) {
                detailsValue = "size=" + variableFormatter.valueToString(sizeValue, formatterOptions);
            } else if (DebugSettings.getCurrent().showToString) {
                detailsValue = VariableDetailUtils.formatDetailsValue(value, frame.thread(), variableFormatter, formatterOptions, evaluationEngine);
            }
            if (detailsValue != null) {
                formattedVariable.value = formattedVariable.value + " " + (String)detailsValue;
            }
            result[i] = formattedVariable;
            calculatedValues.put(inlineVariables[i], formattedVariable);
        }
        response.body = new Responses.InlineValuesResponse(result);
        return CompletableFuture.completedFuture(response);
    }

    private static boolean isCapturedLocalVariable(String fieldName, String variableName) {
        String capturedVariableName = "val$" + variableName;
        return Objects.equals(fieldName, capturedVariableName) || fieldName.startsWith(capturedVariableName + "$") && NumberUtils.isDigits((String)fieldName.substring(capturedVariableName.length() + 1));
    }

    private static boolean isCapturedThisVariable(String fieldName) {
        if (fieldName.startsWith("this$")) {
            String suffix = fieldName.substring(5).replaceAll("\\$+$", "");
            return NumberUtils.isDigits((String)suffix);
        }
        return false;
    }

    private static boolean isLambdaFrame(StackFrame frame) {
        Method method = frame.location().method();
        return method.isSynthetic() && method.name().startsWith("lambda$");
    }

    private void resolveValuesFromThisVariable(ObjectReference thisObj, Requests.InlineVariable[] unresolvedVariables, Variable[] result, boolean isSyntheticLambdaFrame) {
        if (thisObj == null) {
            return;
        }
        int unresolved = 0;
        for (Variable item : result) {
            if (item != null) continue;
            ++unresolved;
        }
        try {
            ReferenceType type = thisObj.referenceType();
            String typeName = type.name();
            ObjectReference enclosingInstance = null;
            for (Field field : type.allFields()) {
                String fieldName = field.name();
                boolean isSyntheticField = field.isSynthetic();
                Value fieldValue = null;
                for (int i = 0; i < unresolvedVariables.length; ++i) {
                    if (result[i] != null) continue;
                    Requests.InlineVariable inlineVariable = unresolvedVariables[i];
                    boolean isInlineFieldVariable = inlineVariable.declaringClass != null;
                    boolean isMatch = false;
                    if (isSyntheticLambdaFrame) {
                        isMatch = !isInlineFieldVariable && Objects.equals(fieldName, inlineVariable.expression);
                    } else {
                        Value value;
                        boolean isMatchedField = isInlineFieldVariable && Objects.equals(fieldName, inlineVariable.expression) && Objects.equals(typeName, inlineVariable.declaringClass);
                        boolean isMatchedCapturedVariable = !isInlineFieldVariable && isSyntheticField && InlineValuesRequestHandler.isCapturedLocalVariable(fieldName, inlineVariable.expression);
                        boolean bl = isMatch = isMatchedField || isMatchedCapturedVariable;
                        if (!isMatch && isSyntheticField && enclosingInstance == null && InlineValuesRequestHandler.isCapturedThisVariable(fieldName) && (value = thisObj.getValue(field)) instanceof ObjectReference) {
                            enclosingInstance = (ObjectReference)value;
                            break;
                        }
                    }
                    if (!isMatch) continue;
                    fieldValue = fieldValue == null ? thisObj.getValue(field) : fieldValue;
                    result[i] = new Variable(inlineVariable.expression, fieldValue);
                    --unresolved;
                }
                if (unresolved > 0) continue;
                break;
            }
            if (unresolved > 0 && enclosingInstance != null) {
                this.resolveValuesFromThisVariable(enclosingInstance, unresolvedVariables, result, isSyntheticLambdaFrame);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

