/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IMethodBreakpoint;
import com.microsoft.java.debug.core.MethodBreakpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.handler.SetBreakpointsRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.MethodEntryEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SetFunctionBreakpointsRequestHandler
implements IDebugRequestHandler {
    private boolean registered = false;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETFUNCTIONBREAKPOINTS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.registered) {
            this.registered = true;
            this.registerMethodBreakpointHandler(context);
        }
        Requests.SetFunctionBreakpointsArguments funcBpArgs = (Requests.SetFunctionBreakpointsArguments)arguments;
        IMethodBreakpoint[] requestedMethodBreakpoints = funcBpArgs.breakpoints == null ? new IMethodBreakpoint[]{} : new MethodBreakpoint[funcBpArgs.breakpoints.length];
        for (int i = 0; i < requestedMethodBreakpoints.length; ++i) {
            String[] segments;
            Types.FunctionBreakpoint funcBreakpoint = funcBpArgs.breakpoints[i];
            if (funcBreakpoint.name == null || (segments = funcBreakpoint.name.split("#")).length != 2 || !StringUtils.isNotBlank((CharSequence)segments[0]) || !StringUtils.isNotBlank((CharSequence)segments[1])) continue;
            int hitCount = 0;
            try {
                hitCount = Integer.parseInt(funcBreakpoint.hitCondition);
            }
            catch (NumberFormatException e) {
                hitCount = 0;
            }
            requestedMethodBreakpoints[i] = context.getDebugSession().createFunctionBreakpoint(segments[0], segments[1], funcBreakpoint.condition, hitCount);
        }
        IMethodBreakpoint[] currentMethodBreakpoints = context.getBreakpointManager().setMethodBreakpoints(requestedMethodBreakpoints);
        ArrayList<Types.Breakpoint> breakpoints = new ArrayList<Types.Breakpoint>();
        for (int i = 0; i < currentMethodBreakpoints.length; ++i) {
            if (currentMethodBreakpoints[i] == null) {
                breakpoints.add(new Types.Breakpoint(false));
                continue;
            }
            currentMethodBreakpoints[i].setAsync(context.asyncJDWP());
            if (currentMethodBreakpoints[i] == requestedMethodBreakpoints[i]) {
                currentMethodBreakpoints[i].install().thenAccept(wp -> {
                    Events.BreakpointEvent bpEvent = new Events.BreakpointEvent("changed", this.convertDebuggerMethodToClient((IMethodBreakpoint)wp));
                    context.getProtocolServer().sendEvent(bpEvent);
                });
            } else {
                if (currentMethodBreakpoints[i].getHitCount() != requestedMethodBreakpoints[i].getHitCount()) {
                    currentMethodBreakpoints[i].setHitCount(requestedMethodBreakpoints[i].getHitCount());
                }
                if (!Objects.equals(currentMethodBreakpoints[i].getCondition(), requestedMethodBreakpoints[i].getCondition())) {
                    currentMethodBreakpoints[i].setCondition(requestedMethodBreakpoints[i].getCondition());
                }
            }
            breakpoints.add(this.convertDebuggerMethodToClient(currentMethodBreakpoints[i]));
        }
        response.body = new Responses.SetDataBreakpointsResponseBody(breakpoints);
        return CompletableFuture.completedFuture(response);
    }

    private Types.Breakpoint convertDebuggerMethodToClient(IMethodBreakpoint methodBreakpoint) {
        return new Types.Breakpoint((Integer)methodBreakpoint.getProperty("id"), methodBreakpoint.getProperty("verified") != null && (Boolean)methodBreakpoint.getProperty("verified") != false);
    }

    private void registerMethodBreakpointHandler(IDebugAdapterContext context) {
        IDebugSession debugSession = context.getDebugSession();
        if (debugSession != null) {
            debugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof MethodEntryEvent).subscribe(debugEvent -> {
                MethodEntryEvent methodEntryEvent = (MethodEntryEvent)debugEvent.event;
                ThreadReference bpThread = methodEntryEvent.thread();
                IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
                IMethodBreakpoint methodBreakpoint = Stream.of(context.getBreakpointManager().getMethodBreakpoints()).filter(mp -> mp.requests().contains(methodEntryEvent.request()) && this.matches(methodEntryEvent, (IMethodBreakpoint)mp)).findFirst().orElse(null);
                if (methodBreakpoint != null) {
                    if (methodBreakpoint instanceof IEvaluatableBreakpoint && ((IEvaluatableBreakpoint)((Object)methodBreakpoint)).containsConditionalExpression()) {
                        if (engine.isInEvaluation(bpThread)) {
                            return;
                        }
                        CompletableFuture.runAsync(() -> engine.evaluateForBreakpoint((IEvaluatableBreakpoint)((Object)methodBreakpoint), bpThread).whenComplete((value, ex) -> {
                            boolean resume = SetBreakpointsRequestHandler.handleEvaluationResult(context, bpThread, (IEvaluatableBreakpoint)((Object)methodBreakpoint), value, ex);
                            engine.clearState(bpThread);
                            if (resume) {
                                debugEvent.eventSet.resume();
                            } else {
                                context.getProtocolServer().sendEvent(new Events.StoppedEvent("function breakpoint", bpThread.uniqueID()));
                            }
                        }));
                    } else {
                        context.getProtocolServer().sendEvent(new Events.StoppedEvent("function breakpoint", bpThread.uniqueID()));
                    }
                    debugEvent.shouldResume = false;
                }
            });
        }
    }

    private boolean matches(MethodEntryEvent methodEntryEvent, IMethodBreakpoint breakpoint) {
        return breakpoint.className().equals(methodEntryEvent.location().declaringType().name()) && breakpoint.methodName().equals(methodEntryEvent.method().name());
    }
}

