/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.google.gson.JsonElement;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.DebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapter;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.handler.AttachRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.BreakpointLocationsRequestHander;
import com.microsoft.java.debug.core.adapter.handler.CompletionsHandler;
import com.microsoft.java.debug.core.adapter.handler.ConfigurationDoneRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.DataBreakpointInfoRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.DisconnectRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.DisconnectRequestWithoutDebuggingHandler;
import com.microsoft.java.debug.core.adapter.handler.EvaluateRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ExceptionInfoRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.HotCodeReplaceHandler;
import com.microsoft.java.debug.core.adapter.handler.InitializeRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.InlineValuesRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.LaunchRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ProcessIdHandler;
import com.microsoft.java.debug.core.adapter.handler.RefreshVariablesHandler;
import com.microsoft.java.debug.core.adapter.handler.RestartFrameHandler;
import com.microsoft.java.debug.core.adapter.handler.ScopesRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetDataBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetExceptionBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetFunctionBreakpointsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetVariableRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SourceRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.StackTraceRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.StepRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ThreadsRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.VariablesRequestHandler;
import com.microsoft.java.debug.core.protocol.IProtocolServer;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugAdapter
implements IDebugAdapter {
    private static final Logger logger = Logger.getLogger("java-debug");
    private IDebugAdapterContext debugContext = null;
    private Map<Requests.Command, List<IDebugRequestHandler>> requestHandlersForDebug = null;
    private Map<Requests.Command, List<IDebugRequestHandler>> requestHandlersForNoDebug = null;

    public DebugAdapter(IProtocolServer server, IProviderContext providerContext) {
        this.debugContext = new DebugAdapterContext(server, providerContext);
        this.requestHandlersForDebug = new HashMap<Requests.Command, List<IDebugRequestHandler>>();
        this.requestHandlersForNoDebug = new HashMap<Requests.Command, List<IDebugRequestHandler>>();
        this.initialize();
    }

    @Override
    public CompletableFuture<Messages.Response> dispatchRequest(Messages.Request request) {
        List<IDebugRequestHandler> handlers;
        Messages.Response response = new Messages.Response();
        response.request_seq = request.seq;
        response.command = request.command;
        response.success = true;
        Requests.Command command = Requests.Command.parse(request.command);
        Requests.Arguments cmdArgs = JsonUtils.fromJson((JsonElement)request.arguments, command.getArgumentType());
        if (this.debugContext.isVmTerminated() && command != Requests.Command.DISCONNECT) {
            return CompletableFuture.completedFuture(response);
        }
        List<IDebugRequestHandler> list = handlers = this.debugContext.getLaunchMode() == LaunchMode.DEBUG ? this.requestHandlersForDebug.get((Object)command) : this.requestHandlersForNoDebug.get((Object)command);
        if (handlers != null && !handlers.isEmpty()) {
            CompletionStage<Messages.Response> future = CompletableFuture.completedFuture(response);
            for (IDebugRequestHandler handler : handlers) {
                future = future.thenCompose(res -> handler.handle(command, cmdArgs, (Messages.Response)res, this.debugContext));
            }
            return future;
        }
        String errorMessage = String.format("Unrecognized request: { _request: %s }", request.command);
        logger.log(Level.SEVERE, errorMessage);
        return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.UNRECOGNIZED_REQUEST_FAILURE, errorMessage);
    }

    private void initialize() {
        this.registerHandler(new InitializeRequestHandler());
        this.registerHandler(new LaunchRequestHandler());
        this.registerHandlerForDebug(new AttachRequestHandler());
        this.registerHandlerForDebug(new ConfigurationDoneRequestHandler());
        this.registerHandlerForDebug(new DisconnectRequestHandler());
        this.registerHandlerForDebug(new SetBreakpointsRequestHandler());
        this.registerHandlerForDebug(new SetExceptionBreakpointsRequestHandler());
        this.registerHandlerForDebug(new SourceRequestHandler());
        this.registerHandlerForDebug(new ThreadsRequestHandler());
        this.registerHandlerForDebug(new StepRequestHandler());
        this.registerHandlerForDebug(new StackTraceRequestHandler());
        this.registerHandlerForDebug(new ScopesRequestHandler());
        this.registerHandlerForDebug(new VariablesRequestHandler());
        this.registerHandlerForDebug(new SetVariableRequestHandler());
        this.registerHandlerForDebug(new EvaluateRequestHandler());
        this.registerHandlerForDebug(new HotCodeReplaceHandler());
        this.registerHandlerForDebug(new RestartFrameHandler());
        this.registerHandlerForDebug(new CompletionsHandler());
        this.registerHandlerForDebug(new ExceptionInfoRequestHandler());
        this.registerHandlerForDebug(new DataBreakpointInfoRequestHandler());
        this.registerHandlerForDebug(new SetDataBreakpointsRequestHandler());
        this.registerHandlerForDebug(new InlineValuesRequestHandler());
        this.registerHandlerForDebug(new RefreshVariablesHandler());
        this.registerHandlerForDebug(new ProcessIdHandler());
        this.registerHandlerForDebug(new SetFunctionBreakpointsRequestHandler());
        this.registerHandlerForDebug(new BreakpointLocationsRequestHander());
        this.registerHandlerForNoDebug(new DisconnectRequestWithoutDebuggingHandler());
        this.registerHandlerForNoDebug(new ProcessIdHandler());
    }

    private void registerHandlerForDebug(IDebugRequestHandler handler) {
        this.registerHandler(this.requestHandlersForDebug, handler);
    }

    private void registerHandlerForNoDebug(IDebugRequestHandler handler) {
        this.registerHandler(this.requestHandlersForNoDebug, handler);
    }

    private void registerHandler(IDebugRequestHandler handler) {
        this.registerHandler(this.requestHandlersForDebug, handler);
        this.registerHandler(this.requestHandlersForNoDebug, handler);
    }

    private void registerHandler(Map<Requests.Command, List<IDebugRequestHandler>> requestHandlers, IDebugRequestHandler handler) {
        for (Requests.Command command : handler.getTargetCommands()) {
            List<IDebugRequestHandler> handlerList = requestHandlers.get((Object)command);
            if (handlerList == null) {
                handlerList = new ArrayList<IDebugRequestHandler>();
                requestHandlers.put(command, handlerList);
            }
            handler.initialize(this.debugContext);
            handlerList.add(handler);
        }
    }
}

