/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ThreadsRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.THREADS, Requests.Command.PAUSE, Requests.Command.CONTINUE, Requests.Command.CONTINUEALL, Requests.Command.CONTINUEOTHERS, Requests.Command.PAUSEALL, Requests.Command.PAUSEOTHERS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Debug Session doesn't exist.");
        }
        switch (command) {
            case THREADS: {
                return this.threads((Requests.ThreadsArguments)arguments, response, context);
            }
            case PAUSE: {
                return this.pause((Requests.PauseArguments)arguments, response, context);
            }
            case CONTINUE: {
                return this.resume((Requests.ContinueArguments)arguments, response, context);
            }
            case CONTINUEALL: {
                return this.resumeAll((Requests.ThreadOperationArguments)arguments, response, context);
            }
            case CONTINUEOTHERS: {
                return this.resumeOthers((Requests.ThreadOperationArguments)arguments, response, context);
            }
            case PAUSEALL: {
                return this.pauseAll((Requests.ThreadOperationArguments)arguments, response, context);
            }
            case PAUSEOTHERS: {
                return this.pauseOthers((Requests.ThreadOperationArguments)arguments, response, context);
            }
        }
        return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.UNRECOGNIZED_REQUEST_FAILURE, String.format("Unrecognized request: { _request: %s }", command.toString()));
    }

    private CompletableFuture<Messages.Response> threads(Requests.ThreadsArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        ArrayList<Types.Thread> threads = new ArrayList<Types.Thread>();
        try {
            List<ThreadReference> allThreads = context.getThreadCache().visibleThreads(context);
            context.getThreadCache().resetThreads(allThreads);
            allThreads = allThreads.stream().filter(thread -> !context.getThreadCache().isDeathThread(thread.uniqueID())).collect(Collectors.toList());
            List<ThreadInfo> jdiThreads = ThreadsRequestHandler.resolveThreadInfos(allThreads, context);
            for (ThreadInfo jdiThread : jdiThreads) {
                String name = StringUtils.isBlank((CharSequence)jdiThread.name) ? String.valueOf(jdiThread.thread.uniqueID()) : jdiThread.name;
                threads.add(new Types.Thread(jdiThread.thread.uniqueID(), "Thread [" + name + "]"));
            }
        }
        catch (ObjectCollectedException | CancellationException | CompletionException runtimeException) {
            // empty catch block
        }
        response.body = new Responses.ThreadsResponseBody(threads);
        return CompletableFuture.completedFuture(response);
    }

    private static List<ThreadInfo> resolveThreadInfos(List<ThreadReference> allThreads, IDebugAdapterContext context) {
        ArrayList<ThreadInfo> threadInfos = new ArrayList<ThreadInfo>(allThreads.size());
        ArrayList futures = new ArrayList();
        for (ThreadReference thread : allThreads) {
            ThreadInfo threadInfo = new ThreadInfo(thread);
            long threadId = thread.uniqueID();
            if (context.getThreadCache().getThreadName(threadId) != null) {
                threadInfo.name = context.getThreadCache().getThreadName(threadId);
            } else if (context.asyncJDWP()) {
                futures.add(AsyncJdwpUtils.runAsync(() -> {
                    threadInfo.name = threadInfo.thread.name();
                    context.getThreadCache().setThreadName(threadId, threadInfo.name);
                }));
            } else {
                threadInfo.name = threadInfo.thread.name();
                context.getThreadCache().setThreadName(threadId, threadInfo.name);
            }
            threadInfos.add(threadInfo);
        }
        AsyncJdwpUtils.await(futures);
        return threadInfos;
    }

    private CompletableFuture<Messages.Response> pause(Requests.PauseArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        ThreadReference thread = context.getThreadCache().getThread(arguments.threadId);
        if (thread == null) {
            thread = DebugUtility.getThread(context.getDebugSession(), arguments.threadId);
        }
        if (thread != null) {
            this.pauseThread(thread, context);
        } else {
            context.getStepResultManager().removeAllMethodResults();
            context.getDebugSession().suspend();
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", arguments.threadId, true));
        }
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resume(Requests.ContinueArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        boolean allThreadsContinued = true;
        ThreadReference thread = context.getThreadCache().getThread(arguments.threadId);
        if (thread == null) {
            thread = DebugUtility.getThread(context.getDebugSession(), arguments.threadId);
        }
        if (thread != null) {
            context.getThreadCache().removeEventThread(arguments.threadId);
            context.getStepResultManager().removeMethodResult(arguments.threadId);
            context.getExceptionManager().removeException(arguments.threadId);
            allThreadsContinued = false;
            DebugUtility.resumeThread(thread);
            ThreadsRequestHandler.checkThreadRunningAndRecycleIds(thread, context);
        } else {
            context.getStepResultManager().removeAllMethodResults();
            context.getExceptionManager().removeAllExceptions();
            this.resumeVM(context);
            context.getRecyclableIdPool().removeAllObjects();
        }
        response.body = new Responses.ContinueResponseBody(allThreadsContinued);
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resumeAll(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        context.getStepResultManager().removeAllMethodResults();
        context.getExceptionManager().removeAllExceptions();
        this.resumeVM(context);
        context.getProtocolServer().sendEvent(new Events.ContinuedEvent(arguments.threadId, true));
        context.getRecyclableIdPool().removeAllObjects();
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resumeOthers(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        List<ThreadReference> threads = context.getThreadCache().visibleThreads(context);
        ArrayList futures = new ArrayList();
        for (ThreadReference thread : threads) {
            if (thread.uniqueID() == arguments.threadId) continue;
            if (context.asyncJDWP()) {
                futures.add(AsyncJdwpUtils.runAsync(() -> this.resumeThread(thread, context)));
                continue;
            }
            this.resumeThread(thread, context);
        }
        AsyncJdwpUtils.await(futures);
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pauseAll(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        context.getDebugSession().suspend();
        context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", arguments.threadId, true));
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pauseOthers(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        List<ThreadReference> threads = context.getThreadCache().visibleThreads(context);
        ArrayList futures = new ArrayList();
        for (ThreadReference thread : threads) {
            if (thread.uniqueID() == arguments.threadId) continue;
            if (context.asyncJDWP()) {
                futures.add(AsyncJdwpUtils.runAsync(() -> this.pauseThread(thread, context)));
                continue;
            }
            this.pauseThread(thread, context);
        }
        AsyncJdwpUtils.await(futures);
        return CompletableFuture.completedFuture(response);
    }

    public static void checkThreadRunningAndRecycleIds(ThreadReference thread, IDebugAdapterContext context) {
        try {
            IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
            engine.clearState(thread);
            context.getRecyclableIdPool().removeObjectsByOwner(thread.uniqueID());
        }
        catch (VMDisconnectedException ex) {
            context.getRecyclableIdPool().removeAllObjects();
        }
        catch (ObjectCollectedException collectedEx) {
            context.getRecyclableIdPool().removeObjectsByOwner(thread.uniqueID());
        }
    }

    private void resumeVM(IDebugAdapterContext context) {
        List<ThreadReference> visibleThreads = context.getThreadCache().visibleThreads(context);
        context.getThreadCache().clearEventThread();
        ArrayList futures = new ArrayList();
        Consumer<ThreadReference> resumeThread = tr -> {
            try {
                while (tr.suspendCount() > 1) {
                    tr.resume();
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        };
        for (ThreadReference tr2 : visibleThreads) {
            if (context.asyncJDWP()) {
                futures.add(AsyncJdwpUtils.runAsync(() -> resumeThread.accept(tr2)));
                continue;
            }
            resumeThread.accept(tr2);
        }
        AsyncJdwpUtils.await(futures);
        context.getDebugSession().getVM().resume();
    }

    private void resumeThread(ThreadReference thread, IDebugAdapterContext context) {
        try {
            context.getThreadCache().removeEventThread(thread.uniqueID());
            int suspends = thread.suspendCount();
            if (suspends > 0) {
                long threadId = thread.uniqueID();
                context.getExceptionManager().removeException(threadId);
                DebugUtility.resumeThread(thread, suspends);
                context.getProtocolServer().sendEvent(new Events.ContinuedEvent(threadId));
                ThreadsRequestHandler.checkThreadRunningAndRecycleIds(thread, context);
            }
        }
        catch (ObjectCollectedException ex) {
            context.getThreadCache().addDeathThread(thread.uniqueID());
        }
    }

    private void pauseThread(ThreadReference thread, IDebugAdapterContext context) {
        try {
            if (!thread.isSuspended() && thread.status() > 0) {
                long threadId = thread.uniqueID();
                context.getStepResultManager().removeMethodResult(threadId);
                thread.suspend();
                context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", threadId));
            }
        }
        catch (ObjectCollectedException ex) {
            context.getThreadCache().addDeathThread(thread.uniqueID());
        }
    }

    static class ThreadInfo {
        public ThreadReference thread;
        public String name;

        public ThreadInfo(ThreadReference thread) {
            this.thread = thread;
        }
    }
}

