/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.microsoft.java.debug.core.protocol.Types;
import java.util.List;

public class Responses {

    public static class InlineValuesResponse
    extends ResponseBody {
        public Types.Variable[] variables;

        public InlineValuesResponse(Types.Variable[] variables) {
            this.variables = variables;
        }
    }

    public static class RedefineClassesResponse
    extends ResponseBody {
        public String[] changedClasses = new String[0];
        public String errorMessage = null;

        public RedefineClassesResponse(String[] changedClasses) {
            this(changedClasses, null);
        }

        public RedefineClassesResponse(String[] changedClasses, String errorMessage) {
            this.changedClasses = changedClasses;
            this.errorMessage = errorMessage;
        }
    }

    public static class ExceptionInfoResponse
    extends ResponseBody {
        public String exceptionId;
        public String description;
        public Types.ExceptionBreakMode breakMode;
        public Types.ExceptionDetails details;

        public ExceptionInfoResponse(String exceptionId, String description, Types.ExceptionBreakMode breakMode) {
            this.exceptionId = exceptionId;
            this.description = description;
            this.breakMode = breakMode;
        }

        public ExceptionInfoResponse(String exceptionId, String description, Types.ExceptionBreakMode breakMode, Types.ExceptionDetails details) {
            this(exceptionId, description, breakMode);
            this.details = details;
        }
    }

    public static class ContinueResponseBody
    extends ResponseBody {
        public boolean allThreadsContinued;

        public ContinueResponseBody() {
            this.allThreadsContinued = true;
        }

        public ContinueResponseBody(boolean allThreadsContinued) {
            this.allThreadsContinued = allThreadsContinued;
        }
    }

    public static class BreakpointLocationsResponseBody
    extends ResponseBody {
        public Types.BreakpointLocation[] breakpoints;

        public BreakpointLocationsResponseBody(Types.BreakpointLocation[] breakpoints) {
            this.breakpoints = breakpoints;
        }
    }

    public static class DataBreakpointInfoResponseBody
    extends ResponseBody {
        public String dataId;
        public String description;
        public Types.DataBreakpointAccessType[] accessTypes;
        public boolean canPersist;

        public DataBreakpointInfoResponseBody(String dataId) {
            this(dataId, null);
        }

        public DataBreakpointInfoResponseBody(String dataId, String description) {
            this(dataId, description, null);
        }

        public DataBreakpointInfoResponseBody(String dataId, String description, Types.DataBreakpointAccessType[] accessTypes) {
            this(dataId, description, accessTypes, false);
        }

        public DataBreakpointInfoResponseBody(String dataId, String description, Types.DataBreakpointAccessType[] accessTypes, boolean canPersist) {
            this.dataId = dataId;
            this.description = description;
            this.accessTypes = accessTypes;
            this.canPersist = canPersist;
        }
    }

    public static class SetDataBreakpointsResponseBody
    extends SetBreakpointsResponseBody {
        public SetDataBreakpointsResponseBody(List<Types.Breakpoint> bpts) {
            super(bpts);
        }
    }

    public static class SetBreakpointsResponseBody
    extends ResponseBody {
        public Types.Breakpoint[] breakpoints;

        public SetBreakpointsResponseBody(List<Types.Breakpoint> bpts) {
            this.breakpoints = bpts == null ? new Types.Breakpoint[0] : bpts.toArray(new Types.Breakpoint[0]);
        }
    }

    public static class CompletionsResponseBody
    extends ResponseBody {
        public Types.CompletionItem[] targets;

        public CompletionsResponseBody(List<Types.CompletionItem> items) {
            this.targets = items == null ? new Types.CompletionItem[0] : items.toArray(new Types.CompletionItem[0]);
        }
    }

    public static class EvaluateResponseBody
    extends ResponseBody {
        public String result;
        public int variablesReference;
        public String type;
        public int indexedVariables;

        public EvaluateResponseBody(String value, int ref, String type, int indexedVariables) {
            this.result = value;
            this.variablesReference = ref;
            this.type = type;
            this.indexedVariables = indexedVariables;
        }
    }

    public static class ThreadsResponseBody
    extends ResponseBody {
        public Types.Thread[] threads;

        public ThreadsResponseBody(List<Types.Thread> vars) {
            this.threads = vars == null ? new Types.Thread[0] : vars.toArray(new Types.Thread[0]);
        }
    }

    public static class SourceResponseBody
    extends ResponseBody {
        public String content;
        public String mimeType = "text/x-java";

        public SourceResponseBody(String content) {
            this.content = content;
        }

        public SourceResponseBody(String content, String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
        }
    }

    public static class SetVariablesResponseBody
    extends ResponseBody {
        public String value;
        public String type;
        public int variablesReference;
        public int indexedVariables;

        public SetVariablesResponseBody(String type, String value, int variablesReference, int indexedVariables) {
            this.type = type;
            this.value = value;
            this.variablesReference = variablesReference;
            this.indexedVariables = indexedVariables;
        }
    }

    public static class VariablesResponseBody
    extends ResponseBody {
        public Types.Variable[] variables;

        public VariablesResponseBody(List<Types.Variable> vars) {
            this.variables = vars == null ? new Types.Variable[0] : vars.toArray(new Types.Variable[0]);
        }
    }

    public static class ScopesResponseBody
    extends ResponseBody {
        public Types.Scope[] scopes;

        public ScopesResponseBody(List<Types.Scope> scps) {
            this.scopes = scps == null ? new Types.Scope[0] : scps.toArray(new Types.Scope[0]);
        }
    }

    public static class StackTraceResponseBody
    extends ResponseBody {
        public Types.StackFrame[] stackFrames;
        public int totalFrames;

        public StackTraceResponseBody(List<Types.StackFrame> frames, int total) {
            this.stackFrames = frames == null ? new Types.StackFrame[0] : frames.toArray(new Types.StackFrame[0]);
            this.totalFrames = total;
        }
    }

    public static class ErrorResponseBody
    extends ResponseBody {
        public Types.Message error;

        public ErrorResponseBody(Types.Message m) {
            this.error = m;
        }
    }

    public static class RunInTerminalResponseBody
    extends ProcessIdResponseBody {
        public RunInTerminalResponseBody(long processId) {
            super(processId);
        }

        public RunInTerminalResponseBody(long processId, long shellProcessId) {
            super(processId, shellProcessId);
        }
    }

    public static class ProcessIdResponseBody
    extends ResponseBody {
        public long processId = -1L;
        public long shellProcessId = -1L;

        public ProcessIdResponseBody(long processId) {
            this.processId = processId;
        }

        public ProcessIdResponseBody(long processId, long shellProcessId) {
            this.processId = processId;
            this.shellProcessId = shellProcessId;
        }
    }

    public static class InitializeResponseBody
    extends ResponseBody {
        public Types.Capabilities body;

        public InitializeResponseBody(Types.Capabilities capabilities) {
            this.body = capabilities;
        }
    }

    public static class ResponseBody {
    }
}

