/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;

public class LaunchUtils {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static Set<Path> tempFilesInUse = new HashSet<Path>();
    private static Path tmpdir = null;

    public static synchronized Path generateClasspathJar(String[] classPaths) throws IOException {
        ArrayList<String> classpathUrls = new ArrayList<String>();
        for (String classpath : classPaths) {
            classpathUrls.add(AdapterUtils.toUrl(classpath));
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String classpathValue = String.join((CharSequence)" ", classpathUrls);
        attributes.put(Attributes.Name.CLASS_PATH, classpathValue);
        String baseName = "cp_" + LaunchUtils.getMd5(classpathValue);
        LaunchUtils.cleanupTempFiles(baseName, ".jar");
        Path tempfile = LaunchUtils.createTempFile(baseName, ".jar");
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(tempfile.toFile()), manifest);
        jar.close();
        LaunchUtils.lockTempLaunchFile(tempfile);
        return tempfile;
    }

    public static synchronized Path generateArgfile(String[] classPaths, String[] modulePaths) throws IOException {
        Object argfile = "";
        if (ArrayUtils.isNotEmpty((Object[])classPaths)) {
            argfile = "-cp \"" + String.join((CharSequence)File.pathSeparator, classPaths) + "\"";
        }
        if (ArrayUtils.isNotEmpty((Object[])modulePaths)) {
            argfile = (String)argfile + " --module-path \"" + String.join((CharSequence)File.pathSeparator, modulePaths) + "\"";
        }
        argfile = ((String)argfile).replace("\\", "\\\\");
        String baseName = "cp_" + LaunchUtils.getMd5((String)argfile);
        LaunchUtils.cleanupTempFiles(baseName, ".argfile");
        Path tempfile = LaunchUtils.createTempFile(baseName, ".argfile");
        Files.write(tempfile, ((String)argfile).getBytes(), new OpenOption[0]);
        LaunchUtils.lockTempLaunchFile(tempfile);
        return tempfile;
    }

    public static void lockTempLaunchFile(Path tempFile) {
        if (tempFile != null) {
            tempFilesInUse.add(tempFile);
        }
    }

    public static void releaseTempLaunchFile(Path tempFile) {
        if (tempFile != null) {
            tempFilesInUse.remove(tempFile);
        }
    }

    public static ProcessHandle findJavaProcessInTerminalShell(long shellPid, String javaCommand, int timeout) {
        ProcessHandle shellProcess = ProcessHandle.of(shellPid).orElse(null);
        if (shellProcess != null) {
            int retry = 0;
            int INTERVAL = 20;
            int maxRetries = timeout / 20;
            boolean isCygwinShell = LaunchUtils.isCygwinShell(shellProcess.info().command().orElse(null));
            while (retry <= maxRetries) {
                long javaPid;
                Optional<ProcessHandle> subProcessHandle = shellProcess.descendants().filter(proc -> {
                    String command = proc.info().command().orElse("");
                    return Objects.equals(command, javaCommand) || command.endsWith("\\java.exe") || command.endsWith("/java");
                }).findFirst();
                if (subProcessHandle.isPresent()) {
                    if (retry > 0) {
                        logger.info("Retried " + retry + " times to find Java subProcess.");
                    }
                    logger.info("shellPid: " + shellPid + ", javaPid: " + subProcessHandle.get().pid());
                    return subProcessHandle.get();
                }
                if (isCygwinShell && (javaPid = LaunchUtils.findJavaProcessByCygwinPsCommand(shellProcess, javaCommand)) > 0L) {
                    if (retry > 0) {
                        logger.info("Retried " + retry + " times to find Java subProcess.");
                    }
                    logger.info("[Cygwin Shell] shellPid: " + shellPid + ", javaPid: " + javaPid);
                    return ProcessHandle.of(javaPid).orElse(null);
                }
                if (++retry > maxRetries) break;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.info("Retried " + retry + " times but failed to find Java subProcess of shell pid " + shellPid);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findJavaProcessByCygwinPsCommand(ProcessHandle shellProcess, String javaCommand) {
        String psCommand = LaunchUtils.detectPsCommandPath(shellProcess.info().command().orElse(null));
        if (psCommand == null) {
            return -1L;
        }
        BufferedReader psReader = null;
        ArrayList<PsProcess> psProcs = new ArrayList<PsProcess>();
        ArrayList<PsProcess> javaCandidates = new ArrayList<PsProcess>();
        try {
            Object[] headers = null;
            int pidIndex = -1;
            int ppidIndex = -1;
            int winpidIndex = -1;
            String javaExeName = Paths.get(javaCommand, new String[0]).toFile().getName().replaceFirst("\\.exe$", "");
            Process p = Runtime.getRuntime().exec(new String[]{psCommand, "-l"});
            psReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (true) {
                String line;
                if ((line = psReader.readLine()) != null) {
                    Object[] cols = line.strip().split("\\s+");
                    if (headers == null) {
                        headers = cols;
                        pidIndex = ArrayUtils.indexOf((Object[])headers, (Object)"PID");
                        ppidIndex = ArrayUtils.indexOf((Object[])headers, (Object)"PPID");
                        winpidIndex = ArrayUtils.indexOf((Object[])headers, (Object)"WINPID");
                        if (pidIndex >= 0 && ppidIndex >= 0 && winpidIndex >= 0) continue;
                        logger.warning("Failed to find Java process because ps command is not the standard Cygwin ps command.");
                        long l = -1L;
                        return l;
                    }
                    if (cols.length < headers.length) continue;
                    long pid = Long.parseLong((String)cols[pidIndex]);
                    long ppid = Long.parseLong((String)cols[ppidIndex]);
                    long winpid = Long.parseLong((String)cols[winpidIndex]);
                    PsProcess process = new PsProcess(pid, ppid, winpid);
                    psProcs.add(process);
                    if (!((String)cols[cols.length - 1]).endsWith("/" + javaExeName) && !((String)cols[cols.length - 1]).endsWith("/java")) continue;
                    javaCandidates.add(process);
                    continue;
                }
                break;
            }
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Failed to find Java process by Cygwin ps command.", err);
        }
        finally {
            if (psReader != null) {
                try {
                    psReader.close();
                }
                catch (IOException err) {}
            }
        }
        if (!javaCandidates.isEmpty()) {
            Set descendantWinpids = shellProcess.descendants().map(proc -> proc.pid()).collect(Collectors.toSet());
            long shellWinpid = shellProcess.pid();
            block15: for (PsProcess javaCandidate : javaCandidates) {
                if (descendantWinpids.contains(javaCandidate.winpid)) {
                    return javaCandidate.winpid;
                }
                for (PsProcess psProc : psProcs) {
                    if (javaCandidate.ppid != psProc.pid) continue;
                    if (!descendantWinpids.contains(psProc.winpid) && psProc.winpid != shellWinpid) continue block15;
                    return javaCandidate.winpid;
                }
            }
        }
        return -1L;
    }

    private static boolean isCygwinShell(String shellPath) {
        if (!SystemUtils.IS_OS_WINDOWS || shellPath == null) {
            return false;
        }
        String lowerShellPath = shellPath.toLowerCase();
        return lowerShellPath.endsWith("git\\bin\\bash.exe") || lowerShellPath.endsWith("git\\usr\\bin\\bash.exe") || lowerShellPath.endsWith("mintty.exe") || lowerShellPath.endsWith("cygwin64\\bin\\bash.exe") || lowerShellPath.endsWith("bash.exe") && LaunchUtils.detectPsCommandPath(shellPath) != null || lowerShellPath.endsWith("sh.exe") && LaunchUtils.detectPsCommandPath(shellPath) != null;
    }

    private static String detectPsCommandPath(String shellPath) {
        if (shellPath == null) {
            return null;
        }
        Path psPath = Paths.get(shellPath, "..\\ps.exe");
        if (!Files.exists(psPath, new LinkOption[0]) && !Files.exists(psPath = Paths.get(shellPath, "..\\..\\usr\\bin\\ps.exe"), new LinkOption[0])) {
            psPath = null;
        }
        if (psPath == null) {
            return null;
        }
        return psPath.normalize().toString();
    }

    private static synchronized Path getTmpDir() throws IOException {
        if (tmpdir == null) {
            Path tmpfile = Files.createTempFile("", UUID.randomUUID().toString(), new FileAttribute[0]);
            tmpdir = tmpfile.getParent();
            try {
                Files.deleteIfExists(tmpfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpdir;
    }

    private static void cleanupTempFiles(String baseName, String suffix) throws IOException {
        int i = 0;
        while (true) {
            Path tempFile;
            if (!tempFilesInUse.contains(tempFile = LaunchUtils.getTmpDir().resolve(baseName + (Serializable)(i == 0 ? "" : Integer.valueOf(i)) + suffix))) {
                if (!Files.exists(tempFile, new LinkOption[0])) break;
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private static Path createTempFile(String baseName, String suffix) throws IOException {
        int i = 0;
        Path tempFile;
        while (Files.exists(tempFile = LaunchUtils.getTmpDir().resolve(baseName + (Serializable)(i == 0 ? "" : Integer.valueOf(i)) + suffix), new LinkOption[0])) {
            ++i;
        }
        return Files.createFile(tempFile, new FileAttribute[0]);
    }

    private static String getMd5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger md5 = new BigInteger(1, messageDigest);
            return md5.toString(36);
        }
        catch (NoSuchAlgorithmException e) {
            return Integer.toString(input.hashCode(), 36);
        }
    }

    private static class PsProcess {
        long pid;
        long ppid;
        long winpid;

        public PsProcess(long pid, long ppid, long winpid) {
            this.pid = pid;
            this.ppid = ppid;
            this.winpid = winpid;
        }
    }
}

