/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.google.gson.JsonSyntaxException;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public final class DebugSettings {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static Set<IDebugSettingChangeListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static DebugSettings current = new DebugSettings();
    public int maxStringLength = 0;
    public int numericPrecision = 0;
    public boolean showStaticVariables = false;
    public boolean showQualifiedNames = false;
    public boolean showHex = false;
    public boolean showLogicalStructure = true;
    public boolean showToString = true;
    public String logLevel;
    public String javaHome;
    public HotCodeReplace hotCodeReplace = HotCodeReplace.MANUAL;
    public Requests.StepFilters stepFilters = new Requests.StepFilters();
    public Requests.ClassFilters exceptionFilters = new Requests.ClassFilters();
    public boolean exceptionFiltersUpdated = false;
    public int limitOfVariablesPerJdwpRequest = 100;
    public int jdwpRequestTimeout = 3000;
    public AsyncMode asyncJDWP = AsyncMode.OFF;

    public static DebugSettings getCurrent() {
        return current;
    }

    public void updateSettings(String jsonSettings) {
        try {
            DebugSettings oldSettings = current;
            current = JsonUtils.fromJson(jsonSettings, DebugSettings.class);
            for (IDebugSettingChangeListener listener : listeners) {
                listener.update(oldSettings, current);
            }
        }
        catch (JsonSyntaxException ex) {
            logger.severe(String.format("Invalid json for debugSettings: %s, %s", jsonSettings, ex.getMessage()));
        }
    }

    private DebugSettings() {
    }

    public static boolean addDebugSettingChangeListener(IDebugSettingChangeListener listener) {
        return listeners.add(listener);
    }

    public static boolean removeDebugSettingChangeListener(IDebugSettingChangeListener listener) {
        return listeners.remove(listener);
    }

    public static interface IDebugSettingChangeListener {
        public void update(DebugSettings var1, DebugSettings var2);
    }

    public static enum HotCodeReplace {
        MANUAL,
        AUTO,
        NEVER;

    }

    public static enum AsyncMode {
        AUTO,
        ON,
        OFF;

    }
}

