/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.IWatchpoint;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.WatchpointRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class Watchpoint
implements IWatchpoint,
IEvaluatableBreakpoint {
    private final VirtualMachine vm;
    private final IEventHub eventHub;
    private final String className;
    private final String fieldName;
    private String accessType = null;
    private String condition = null;
    private int hitCount;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private Object compiledConditionalExpression = null;
    private Map<Long, Object> compiledExpressions = new ConcurrentHashMap<Long, Object>();
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    Watchpoint(VirtualMachine vm, IEventHub eventHub, String className, String fieldName) {
        this(vm, eventHub, className, fieldName, "write");
    }

    Watchpoint(VirtualMachine vm, IEventHub eventHub, String className, String fieldName, String accessType) {
        this(vm, eventHub, className, fieldName, accessType, null, 0);
    }

    Watchpoint(VirtualMachine vm, IEventHub eventHub, String className, String fieldName, String accessType, String condition, int hitCount) {
        Objects.requireNonNull(vm);
        Objects.requireNonNull(eventHub);
        Objects.requireNonNull(className);
        Objects.requireNonNull(fieldName);
        this.vm = vm;
        this.eventHub = eventHub;
        this.className = className;
        this.fieldName = fieldName;
        this.accessType = accessType;
        this.condition = condition;
        this.hitCount = hitCount;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(subscription -> subscription.dispose());
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public String accessType() {
        return this.accessType;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
        this.setCompiledConditionalExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
        Observable.fromIterable(this.requests()).filter(request -> request instanceof WatchpointRequest).subscribe(request -> {
            request.addCountFilter(hitCount);
            request.enable();
        });
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.propertyMap.put(key, value);
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertyMap.get(key);
    }

    @Override
    public CompletableFuture<IWatchpoint> install() {
        Disposable subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ThreadDeathEvent).subscribe(debugEvent -> {
            ThreadReference deathThread = ((ThreadDeathEvent)debugEvent.event).thread();
            this.compiledExpressions.remove(deathThread.uniqueID());
        });
        this.subscriptions.add(subscription);
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className);
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        CompletableFuture<IWatchpoint> future = new CompletableFuture<IWatchpoint>();
        subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && classPrepareRequest.equals(debugEvent.event.request())).subscribe(debugEvent -> {
            ClassPrepareEvent event = (ClassPrepareEvent)debugEvent.event;
            List<WatchpointRequest> watchpointRequests = this.createWatchpointRequests(event.referenceType());
            this.requests.addAll(watchpointRequests);
            if (!watchpointRequests.isEmpty() && !future.isDone()) {
                this.putProperty("verified", true);
                future.complete(this);
            }
        });
        this.subscriptions.add(subscription);
        ArrayList<WatchpointRequest> watchpointRequests = new ArrayList<WatchpointRequest>();
        List<ReferenceType> types = this.vm.classesByName(this.className);
        for (ReferenceType type : types) {
            watchpointRequests.addAll(this.createWatchpointRequests(type));
        }
        this.requests.addAll(watchpointRequests);
        if (!watchpointRequests.isEmpty() && !future.isDone()) {
            this.putProperty("verified", true);
            future.complete(this);
        }
        return future;
    }

    private List<WatchpointRequest> createWatchpointRequests(ReferenceType type) {
        ArrayList<WatchpointRequest> watchpointRequests = new ArrayList<WatchpointRequest>();
        Field field = type.fieldByName(this.fieldName);
        if (field != null) {
            if ("read".equals(this.accessType)) {
                watchpointRequests.add(this.vm.eventRequestManager().createAccessWatchpointRequest(field));
            } else if ("readWrite".equals(this.accessType)) {
                watchpointRequests.add(this.vm.eventRequestManager().createAccessWatchpointRequest(field));
                watchpointRequests.add(this.vm.eventRequestManager().createModificationWatchpointRequest(field));
            } else {
                watchpointRequests.add(this.vm.eventRequestManager().createModificationWatchpointRequest(field));
            }
        }
        watchpointRequests.forEach(request -> {
            request.setSuspendPolicy(1);
            if (this.hitCount > 0) {
                request.addCountFilter(this.hitCount);
            }
            request.enable();
        });
        return watchpointRequests;
    }

    @Override
    public String getLogMessage() {
        return null;
    }

    @Override
    public void setLogMessage(String logMessage) {
        throw new UnsupportedOperationException("Log message feature is unsupported for watchpoint.");
    }

    @Override
    public boolean containsEvaluatableExpression() {
        return this.containsConditionalExpression();
    }

    @Override
    public boolean containsConditionalExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getCondition());
    }

    @Override
    public boolean containsLogpointExpression() {
        return false;
    }

    @Override
    public void setCompiledConditionalExpression(Object compiledExpression) {
        this.compiledConditionalExpression = compiledExpression;
    }

    @Override
    public Object getCompiledConditionalExpression() {
        return this.compiledConditionalExpression;
    }

    @Override
    public void setCompiledLogpointExpression(Object compiledExpression) {
    }

    @Override
    public Object getCompiledLogpointExpression() {
        return null;
    }

    @Override
    public Object getCompiledExpression(long threadId) {
        return this.compiledExpressions.get(threadId);
    }

    @Override
    public void setCompiledExpression(long threadId, Object compiledExpression) {
        this.compiledExpressions.put(threadId, compiledExpression);
    }
}

